<?php
session_start();

function login($email, $password, $role) {
    global $pdo;
    $table = $role === 'teacher' ? 'teachers' : 'students';
    
    $stmt = $pdo->prepare("SELECT * FROM $table WHERE email = ? AND status != 'banned'");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user'] = $user;
        $_SESSION['role'] = $role;
        return true;
    }
    return false;
}

function isLoggedIn() {
    return isset($_SESSION['user']);
}

function logout() {
    session_destroy();
    header("Location: ../login.php");
    exit();
}

function isTeacher() {
    return isLoggedIn() && $_SESSION['role'] === 'teacher';
}

function isStudent() {
    return isLoggedIn() && $_SESSION['role'] === 'student';
}
?>