<?php
require_once 'auth.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>اشراق</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #7209b7;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #2b2d42;
            --gray: #6c757d;
            --border-radius: 12px;
            --shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Cairo', sans-serif;
        }

        body {
            background: #f4f6f9;
            color: var(--dark);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* الترويسة */
        header {
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            padding: 15px 0;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
            position: relative;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 24px;
            font-weight: 700;
            z-index: 1001;
        }

        nav ul {
            list-style: none;
            display: flex;
            gap: 10px;
        }

        nav a {
            color: white;
            text-decoration: none;
            font-weight: 600;
            padding: 8px 15px;
            border-radius: var(--border-radius);
            transition: var(--transition);
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 15px;
        }

        nav a:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .user-menu {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .user-badge {
            background: rgba(255, 255, 255, 0.2);
            padding: 8px 15px;
            border-radius: var(--border-radius);
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: var(--border-radius);
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }

        .btn-outline {
            background: transparent;
            border: 2px solid white;
            color: white;
        }

        .btn-outline:hover {
            background: white;
            color: var(--primary);
        }

        /* قائمة الهاتف */
        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 24px;
            cursor: pointer;
            z-index: 1001;
        }

        /* المحتوى الرئيسي */
        .container {
            width: 90%;
            max-width: 1200px;
            margin: 30px auto;
            flex: 1;
        }

        /* بطاقات الدروس */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
            margin: 40px 0;
        }

        .card {
            background: white;
            border-radius: var(--border-radius);
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: var(--transition);
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
        }

        .card-img {
            height: 180px;
            background: linear-gradient(45deg, #4361ee, #3a0ca3);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 50px;
        }

        .card-content {
            padding: 20px;
        }

        .card h3 {
            margin-bottom: 10px;
            color: var(--dark);
        }

        .card p {
            color: var(--gray);
            margin-bottom: 15px;
            font-size: 15px;
        }

        .card-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }

        .card-btn {
            padding: 8px 16px;
            background: var(--primary);
            color: white;
            border-radius: var(--border-radius);
            text-decoration: none;
            font-size: 14px;
            transition: var(--transition);
        }

        .card-btn:hover {
            background: var(--primary-dark);
        }

        /* التكيف مع الشاشات الصغيرة */
        @media (max-width: 992px) {
            nav a {
                font-size: 14px;
                padding: 8px 12px;
            }
            
            .user-badge span {
                display: none;
            }
        }

        @media (max-width: 768px) {
            .header-content {
                flex-wrap: wrap;
            }
            
            .mobile-menu-btn {
                display: block;
            }
            
            nav {
                position: fixed;
                top: 0;
                right: -100%;
                width: 80%;
                max-width: 300px;
                height: 100vh;
                background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
                padding: 80px 20px 20px;
                transition: var(--transition);
                z-index: 1000;
                box-shadow: -5px 0 15px rgba(0, 0, 0, 0.1);
            }
            
            nav.active {
                right: 0;
            }
            
            nav ul {
                flex-direction: column;
                gap: 15px;
            }
            
            nav a {
                font-size: 16px;
                padding: 12px 15px;
                justify-content: flex-start;
            }
            
            .user-menu {
                position: fixed;
                bottom: 0;
                right: -100%;
                width: 80%;
                max-width: 300px;
                padding: 20px;
                background: rgba(255, 255, 255, 0.1);
                backdrop-filter: blur(10px);
                flex-direction: column;
                gap: 15px;
                transition: var(--transition);
                z-index: 1000;
                border-top: 1px solid rgba(255, 255, 255, 0.2);
            }
            
            .user-menu.active {
                right: 0;
            }
            
            .user-badge span {
                display: inline;
            }
            
            .cards-grid {
                grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            }
        }

        @media (max-width: 576px) {
            .logo span {
                font-size: 18px;
            }
            
            .cards-grid {
                grid-template-columns: 1fr;
            }
            
            .header-content {
                width: 95%;
            }
            
            .container {
                width: 95%;
            }
        }

        /* قسم الترحيب */
        .welcome-section {
            text-align: center;
            padding: 40px 20px;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            margin-bottom: 40px;
        }

        .welcome-section h1 {
            font-size: 2.2rem;
            color: var(--primary);
            margin-bottom: 20px;
        }

        .welcome-section p {
            font-size: 1.1rem;
            color: var(--gray);
            max-width: 700px;
            margin: 0 auto 30px;
            line-height: 1.8;
        }

        .btn-group {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
            padding: 12px 25px;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
        }

        .btn-secondary {
            background: var(--secondary);
            color: white;
            padding: 12px 25px;
        }

        .btn-secondary:hover {
            background: #5a08a0;
        }

        @media (max-width: 576px) {
            .welcome-section h1 {
                font-size: 1.8rem;
            }
            
            .welcome-section p {
                font-size: 1rem;
            }
            
            .btn-group {
                flex-direction: column;
                align-items: center;
            }
            
            .btn-primary, .btn-secondary {
                width: 100%;
                max-width: 250px;
                justify-content: center;
            }
        }

        /* عنصر تغطية الخلفية عند فتح القائمة */
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: var(--transition);
        }

        .overlay.active {
            opacity: 1;
            visibility: visible;
        }
    </style>
</head>
<body>
    <div class="overlay" id="overlay"></div>
    
    <header>
        <div class="header-content">
            <div class="logo">
                <i class="fas fa-graduation-cap"></i>
                <span>اشراق</span>
            </div>

            <button class="mobile-menu-btn" id="mobileMenuBtn">
                <i class="fas fa-bars"></i>
            </button>

            <?php if (isLoggedIn()): ?>
                <nav id="mainNav">
                    <?php if (isTeacher()): ?>
                        <ul>
                            <li><a href="../teacher/dashboard.php"><i class="fas fa-tachometer-alt"></i> لوحة التحكم</a></li>
                            <li><a href="../teacher/add_lesson.php"><i class="fas fa-plus-circle"></i> إضافة درس</a></li>
                            <li><a href="../teacher/manage_students.php"><i class="fas fa-users"></i> الطلاب</a></li>
                            <li><a href="../teacher/homeworks.php"><i class="fas fa-tasks"></i> الواجبات</a></li>
                             <li><a href="../teacher/upload_material.php"><i class="fas fa-upload"></i> رفع مادة </a></li>
                            <li><a href="../teacher/settings.php"><i class="fas fa-cog"></i> الإعدادات</a></li>
                        </ul>
                    <?php elseif (isStudent()): ?>
                        <ul>
                            <li><a href="../student/dashboard.php"><i class="fas fa-book-open"></i> الدروس</a></li>
                            <li><a href="../student/homeworks.php"><i class="fas fa-tasks"></i> الواجبات</a></li>
                            <li><a href="../student/profile.php"><i class="fas fa-user"></i> الملف الشخصي</a></li>
                        </ul>
                    <?php endif; ?>
                </nav>

                <div class="user-menu" id="userMenu">
                    <div class="user-badge">
                        <i class="fas fa-user-circle"></i>
                        <span><?php echo $_SESSION['user']['name']; ?></span>
                    </div>
                    <a href="<?php echo isTeacher() ? '../teacher/logout.php' : '../student/logout.php'; ?>" class="btn btn-outline">
                        <i class="fas fa-sign-out-alt"></i> تسجيل الخروج
                    </a>
                </div>
            <?php else: ?>
                <nav id="mainNav">
                    <ul>
                        <li><a href="../index.php"><i class="fas fa-home"></i> الرئيسية</a></li>
                        <li><a href="../login.php"><i class="fas fa-chalkboard-teacher"></i> مُدرِّس</a></li>
                        <li><a href="../login.php"><i class="fas fa-user-graduate"></i> طالب</a></li>
                    </ul>
                </nav>
                
                <div class="user-menu" id="userMenu">
                    <a href="../login.php?role=teacher" class="btn btn-outline">
                        <i class="fas fa-sign-in-alt"></i> تسجيل الدخول
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </header>

    <main class="container">
        <!-- محتوى الصفحة الرئيسية -->
        <?php if (!isLoggedIn()): ?>
            <section class="welcome-section">
                <h1>مرحباً بكم في اشراق</h1>
                <p>منصة تعليمية متكاملة توفر تجربة تعلم فريدة للطلاب وأدوات تدريس متطورة للمعلمين. انضم إلى آلاف المستخدمين الذين يستفيدون من محتوانا التعليمي المتميز.</p>
                <div class="btn-group">
                    <a href="../login.php?role=teacher" class="btn btn-primary">
                        <i class="fas fa-chalkboard-teacher"></i> تسجيل دخول مدرس
                    </a>
                    <a href="../login.php?role=student" class="btn btn-secondary">
                        <i class="fas fa-user-graduate"></i> تسجيل دخول طالب
                    </a>
                </div>
            </section>
            
               
                
                
               
        <?php endif; ?>
    </main>

    <script>
        // تفعيل القائمة المتنقلة
        const mobileMenuBtn = document.getElementById('mobileMenuBtn');
        const nav = document.getElementById('mainNav');
        const userMenu = document.getElementById('userMenu');
        const overlay = document.getElementById('overlay');
        
        function toggleMenu() {
            nav.classList.toggle('active');
            if (userMenu) {
                userMenu.classList.toggle('active');
            }
            overlay.classList.toggle('active');
            
            // تغيير الأيقونة
            const icon = mobileMenuBtn.querySelector('i');
            if (nav.classList.contains('active')) {
                icon.classList.remove('fa-bars');
                icon.classList.add('fa-times');
                document.body.style.overflow = 'hidden';
            } else {
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
                document.body.style.overflow = 'auto';
            }
        }
        
        mobileMenuBtn.addEventListener('click', toggleMenu);
        overlay.addEventListener('click', toggleMenu);

        // إغلاق القائمة عند النقر على رابط
        const navLinks = document.querySelectorAll('nav a');
        navLinks.forEach(link => {
            link.addEventListener('click', () => {
                if (window.innerWidth <= 768) {
                    toggleMenu();
                }
            });
        });
    </script>
</body>
</html>