<?php
require_once 'includes/db.php';
require_once 'includes/auth.php';

// التحقق من أن التسجيل مفتوح
$stmt = $pdo->query("SELECT registration_open FROM settings WHERE registration_open = 1 LIMIT 1");
if ($stmt->rowCount() == 0) {
    die("عذرًا، التسجيل مغلق حاليًا.");
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $class_id = $_POST['class_id'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $image_url = 'uploads/default.png';

    // رفع الصورة إن وُجدت
    if (!empty($_FILES['image']['name'])) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $filename = uniqid() . '.' . $ext;
        $path = 'assets/uploads/' . $filename;
        if (move_uploaded_file($_FILES['image']['tmp_name'], $path)) {
            $image_url = 'uploads/' . $filename;
        }
    }

    try {
        $stmt = $pdo->prepare("INSERT INTO students (name, email, password, phone, image_url, class_id) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$name, $email, $password, $phone, $image_url, $class_id]);
        $success = "تم التسجيل بنجاح! يمكنك الآن تسجيل الدخول.";
    } catch (Exception $e) {
        $error = "خطأ: هذا البريد مستخدم مسبقًا.";
    }
}

// جلب الصفوف
$classes = $pdo->query("SELECT * FROM classes")->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل طالب جديد</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #7209b7;
            --accent: #f72585;
            --success: #4cc9f0;
            --text: #2b2d42;
            --text-light: #6c757d;
            --light: #f8f9fa;
            --white: #ffffff;
            --border: #dee2e6;
            --border-radius: 12px;
            --shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            color: var(--text);
            line-height: 1.6;
        }
        
        .container {
            width: 100%;
            max-width: 800px;
            background: var(--white);
            border-radius: 20px;
            box-shadow: var(--shadow);
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .header {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            color: var(--white);
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        .header h2 {
            font-size: 28px;
            margin-bottom: 10px;
            font-weight: 700;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 16px;
        }
        
        .content {
            padding: 30px;
        }
        
        .alert {
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 15px;
            font-size: 16px;
        }
        
        .alert-error {
            background-color: #ffebee;
            color: #d32f2f;
            border: 1px solid #f44336;
        }
        
        .alert-success {
            background-color: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #4caf50;
        }
        
        .form-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--text);
            font-size: 16px;
        }
        
        input, select {
            width: 100%;
            padding: 15px;
            border: 2px solid var(--border);
            border-radius: var(--border-radius);
            font-size: 16px;
            transition: var(--transition);
            background: var(--light);
        }
        
        input:focus, select:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }
        
        .input-with-icon {
            position: relative;
        }
        
        .input-with-icon i {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-light);
        }
        
        .input-with-icon input {
            padding-right: 45px;
        }
        
        .file-input-container {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
        }
        
        .file-input-container input[type="file"] {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }
        
        .file-input-button {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            padding: 15px;
            background-color: var(--light);
            border: 2px dashed var(--border);
            border-radius: var(--border-radius);
            text-align: center;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .file-input-button:hover {
            background-color: #e9e9e9;
            border-color: var(--primary);
        }
        
        button {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            color: var(--white);
            border: none;
            padding: 16px;
            border-radius: var(--border-radius);
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: var(--transition);
            margin-top: 10px;
        }
        
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.4);
        }
        
        .back-link {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            font-size: 16px;
        }
        
        .back-link:hover {
            color: var(--secondary);
            text-decoration: underline;
        }
        
        /* تحسينات للهاتف */
        @media (max-width: 768px) {
            .container {
                border-radius: 15px;
            }
            
            .header {
                padding: 20px;
            }
            
            .header h2 {
                font-size: 24px;
            }
            
            .content {
                padding: 20px;
            }
            
            input, select, button {
                padding: 12px;
            }
            
            .alert {
                flex-direction: column;
                text-align: center;
                gap: 10px;
            }
        }
        
        /* تحسينات إضافية للشاشات الكبيرة */
        @media (min-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr 1fr;
                gap: 20px;
            }
            
            .form-group.full-width {
                grid-column: 1 / span 2;
            }
        }
        
        /* تحسينات للتنسيق العام */
        .logo {
            text-align: center;
            margin-bottom: 15px;
        }
        
        .logo i {
            font-size: 40px;
            color: var(--white);
            background: var(--accent);
            width: 80px;
            height: 80px;
            line-height: 80px;
            border-radius: 50%;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">
                <i class="fas fa-graduation-cap"></i>
            </div>
            <h2>إنشاء حساب طالب</h2>
            <p>املأ النموذج أدناه لتسجيل حساب جديد في النظام</p>
        </div>
        
        <div class="content">
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <p><?php echo $error; ?></p>
                </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <p><?php echo $success; ?></p>
                </div>
            <?php endif; ?>

            <form method="POST" enctype="multipart/form-data">
                <div class="form-grid">
                    <div class="form-group">
                        <label for="name">الاسم الكامل</label>
                        <div class="input-with-icon">
                            <i class="fas fa-user"></i>
                            <input type="text" id="name" name="name" placeholder="أدخل الاسم الكامل" required>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="email">البريد الإلكتروني</label>
                        <div class="input-with-icon">
                            <i class="fas fa-envelope"></i>
                            <input type="email" id="email" name="email" placeholder="أدخل البريد الإلكتروني" required>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">كلمة المرور</label>
                        <div class="input-with-icon">
                            <i class="fas fa-lock"></i>
                            <input type="password" id="password" name="password" placeholder="اختر كلمة مرور قوية" required>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="phone">رقم الهاتف</label>
                        <div class="input-with-icon">
                            <i class="fas fa-phone"></i>
                            <input type="text" id="phone" name="phone" placeholder="أدخل رقم الهاتف">
                        </div>
                    </div>
                    
                    <div class="form-group full-width">
                        <label for="image">صورة الشخصية (اختياري)</label>
                        <div class="file-input-container">
                            <div class="file-input-button">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span>اختر صورة للملف الشخصي</span>
                            </div>
                            <input type="file" id="image" name="image" accept="image/*">
                        </div>
                    </div>
                    
                    <div class="form-group full-width">
                        <label for="class_id">الصف الدراسي</label>
                        <select id="class_id" name="class_id" required>
                            <option value="">اختر الصف الدراسي</option>
                            <?php foreach ($classes as $class): ?>
                                <option value="<?php echo $class['id']; ?>"><?php echo $class['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                
                <button type="submit">
                    <i class="fas fa-user-plus"></i> تسجيل الحساب
                </button>
            </form>
            
            <a href="login.php" class="back-link">
                <i class="fas fa-arrow-right"></i> العودة إلى صفحة تسجيل الدخول
            </a>
        </div>
    </div>

    <script>
        // عرض اسم الملف عند اختياره
        document.querySelector('input[type="file"]').addEventListener('change', function(e) {
            const fileName = e.target.files[0]?.name || 'لم يتم اختيار ملف';
            document.querySelector('.file-input-button span').textContent = fileName;
        });
        
        // تأثيرات عند التركيز على الحقول
        const inputs = document.querySelectorAll('input, select');
        inputs.forEach(input => {
            input.addEventListener('focus', () => {
                input.parentElement.classList.add('focused');
            });
            input.addEventListener('blur', () => {
                input.parentElement.classList.remove('focused');
            });
        });
    </script>
</body>
</html>