<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isStudent()) {
    header("Location: ../index.php");
    exit();
}

$student = $_SESSION['user'];
$student_id = $student['id'];
$error = '';
$success = '';

// --- معالجة إرسال تعليق جديد ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_comment'])) {
    $homework_id = $_POST['homework_id'];
    $message = trim($_POST['message']);

    if (empty($message)) {
        $error = "لا يمكن إرسال رسالة فارغة.";
    } else {
        // تأكد أن الطالب قدّم هذا الواجب
        $stmt = $pdo->prepare("SELECT id FROM submissions WHERE homework_id = ? AND student_id = ?");
        $stmt->execute([$homework_id, $student_id]);
        $submission = $stmt->fetch();

        if (!$submission) {
            $error = "يجب تسليم الواجب أولًا قبل التعليق.";
        } else {
            try {
                $stmt = $pdo->prepare("INSERT INTO submission_comments (submission_id, sender_type, message) VALUES (?, ?, ?)");
                $stmt->execute([$submission['id'], 'student', $message]);
                $success = "تم إرسال تعليقك بنجاح!";
                // إعادة التحميل لعرض التعليق
                echo "<script>setTimeout(() => { window.location.href = window.location.href; }, 1000);</script>";
            } catch (Exception $e) {
                $error = "حدث خطأ أثناء الإرسال.";
            }
        }
    }
}

// --- معالجة تقديم الواجب (مرة واحدة فقط) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['submit_homework'])) {
    $homework_id = $_POST['homework_id'];
    $note = trim($_POST['note']);

    // التحقق من وجود الواجب
    $stmt = $pdo->prepare("SELECT id, due_date FROM homeworks WHERE id = ?");
    $stmt->execute([$homework_id]);
    $hw = $stmt->fetch();

    if (!$hw) {
        $error = "الواجب غير موجود.";
    } else {
        // التحقق من انتهاء المدة
        $due = $hw['due_date'] ? new DateTime($hw['due_date']) : null;
        $now = new DateTime();
        if ($due && $now > $due) {
            $error = "انتهت مدة تسليم هذا الواجب.";
        } else {
            // التحقق من أن الطالب لم يُقدّم من قبل
            $stmt = $pdo->prepare("SELECT id FROM submissions WHERE homework_id = ? AND student_id = ?");
            $stmt->execute([$homework_id, $student_id]);
            if ($stmt->rowCount() > 0) {
                $error = "لقد قدمت هذا الواجب مسبقًا. لا يمكن إعادة التسليم.";
            } else {
                // رفع ملف الإجابة
                if (empty($_FILES['file']['name'])) {
                    $error = "يرجى رفع ملف الإجابة.";
                } else {
                    $ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                    $allowed = ['pdf', 'jpg', 'jpeg', 'png', 'doc', 'docx'];
                    if (!in_array(strtolower($ext), $allowed)) {
                        $error = "نوع الملف غير مسموح به.";
                    } else {
                        $filename = 'submissions/' . uniqid() . '.' . $ext;
                        $path = '../assets/uploads/' . $filename;

                        if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                            try {
                                $stmt = $pdo->prepare("INSERT INTO submissions (homework_id, student_id, file_path, note) VALUES (?, ?, ?, ?)");
                                $stmt->execute([$homework_id, $student_id, $filename, $note]);
                                $success = "تم تسليم الواجب بنجاح!";
                                echo "<script>setTimeout(() => { window.location.href = window.location.href; }, 1500);</script>";
                            } catch (Exception $e) {
                                $error = "حدث خطأ أثناء التسليم.";
                            }
                        } else {
                            $error = "فشل رفع الملف.";
                        }
                    }
                }
            }
        }
    }
}

// --- جلب اسم الصف ---
$stmt = $pdo->prepare("SELECT name FROM classes WHERE id = ?");
$stmt->execute([$student['class_id']]);
$class = $stmt->fetch();
$class_name = $class ? htmlspecialchars($class['name']) : 'غير معروف';

// --- جلب الواجبات ---
$stmt = $pdo->prepare("SELECT h.*, t.name as teacher_name FROM homeworks h
                       JOIN teachers t ON h.teacher_id = t.id
                       WHERE h.class_id = ?
                       ORDER BY h.due_date ASC, h.created_at DESC");
$stmt->execute([$student['class_id']]);
$homeworks = $stmt->fetchAll();

// --- جلب الإجابات + التعليقات ---
$submissions = [];
$comments = [];

foreach ($homeworks as $hw) {
    $stmt = $pdo->prepare("SELECT id, file_path, note FROM submissions WHERE homework_id = ? AND student_id = ?");
    $stmt->execute([$hw['id'], $student_id]);
    $sub = $stmt->fetch();
    if ($sub) {
        $submissions[$hw['id']] = $sub;

        // جلب التعليقات لهذا التسليم
        $stmt = $pdo->prepare("SELECT * FROM submission_comments WHERE submission_id = ? ORDER BY created_at ASC");
        $stmt->execute([$sub['id']]);
        $comment_list = $stmt->fetchAll();
        $comments[$hw['id']] = $comment_list;
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الواجبات - اشراق</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #7209b7;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #2b2d42;
            --gray: #6c757d;
            --success: #4cc9f0;
            --error: #d9534f;
            --warning: #ffc107;
            --border-radius: 12px;
            --shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Cairo', sans-serif;
        }

        body {
            background: #f4f6f9;
            color: var(--dark);
            line-height: 1.6;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
        }

        /* شريط التنقل العلوي */
        .top-nav {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding: 15px 25px;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 700;
            font-size: 20px;
            color: var(--primary);
        }

        .nav-links {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 15px;
            border-radius: var(--border-radius);
            color: var(--dark);
            text-decoration: none;
            transition: var(--transition);
        }

        .nav-link:hover {
            background: var(--light);
            color: var(--primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        /* رأس الصفحة */
        .page-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .page-header h1 {
            font-size: 32px;
            color: var(--primary);
            margin-bottom: 10px;
        }

        .page-header p {
            color: var(--gray);
            font-size: 18px;
        }

        /* رسائل الحالة */
        .alert {
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .alert-error {
            background: #ffebee;
            color: var(--error);
            border: 1px solid #f5c6cb;
        }

        .alert-success {
            background: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c3e6cb;
        }

        /* قائمة الواجبات */
        .homeworks-container {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .homework-card {
            background: white;
            padding: 25px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .homework-card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--primary);
        }

        .homework-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }

        .homework-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }

        .homework-title {
            font-size: 20px;
            color: var(--primary);
            margin-bottom: 5px;
        }

        .homework-status {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: bold;
        }

        .status-pending {
            background: var(--warning);
            color: white;
        }

        .status-submitted {
            background: var(--success);
            color: white;
        }

        .status-overdue {
            background: var(--error);
            color: white;
        }

        .homework-meta {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-bottom: 15px;
            font-size: 14px;
            color: var(--gray);
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .homework-description {
            color: var(--dark);
            margin-bottom: 15px;
            line-height: 1.6;
            padding: 15px;
            background: #f8f9fa;
            border-radius: var(--border-radius);
        }

        /* قسم التسليم */
        .submission-section {
            margin-top: 20px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: var(--border-radius);
            border: 1px solid #dee2e6;
        }

        .submission-header {
            font-size: 18px;
            color: var(--dark);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .file-download {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 15px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: var(--border-radius);
            font-weight: 600;
            transition: var(--transition);
        }

        .file-download:hover {
            background: var(--primary-dark);
        }

        .submission-note {
            margin: 15px 0;
            padding: 15px;
            background: white;
            border-radius: var(--border-radius);
            border: 1px solid #dee2e6;
        }

        /* قسم التعليقات */
        .comments-section {
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px dashed #ccc;
        }

        .comments-title {
            font-size: 18px;
            color: var(--dark);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .comments-container {
            max-height: 300px;
            overflow-y: auto;
            padding: 15px;
            background: white;
            border-radius: var(--border-radius);
            border: 1px solid #ddd;
            margin-bottom: 15px;
        }

        .comment {
            margin-bottom: 15px;
            padding: 12px;
            border-radius: var(--border-radius);
            background: #f8f9fa;
            border: 1px solid #dee2e6;
        }

        .comment-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
        }

        .comment-sender {
            font-weight: 600;
            color: var(--primary);
        }

        .comment-time {
            font-size: 12px;
            color: var(--gray);
        }

        .comment-message {
            color: var(--dark);
            line-height: 1.5;
        }

        .comment-form textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 16px;
            transition: var(--transition);
            margin-bottom: 10px;
            resize: vertical;
            min-height: 80px;
        }

        .comment-form textarea:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }

        /* نموذج التسليم */
        .submit-form {
            margin-top: 20px;
            padding: 20px;
            background: white;
            border-radius: var(--border-radius);
            border: 1px solid #dee2e6;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
        }

        .form-input {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 16px;
            transition: var(--transition);
        }

        .form-input:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }

        .file-input-container {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
            margin-top: 10px;
        }

        .file-input-button {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            padding: 12px;
            background: #f8f9fa;
            border: 2px dashed #ddd;
            border-radius: var(--border-radius);
            text-align: center;
            cursor: pointer;
            transition: var(--transition);
            width: 100%;
        }

        .file-input-button:hover {
            background: #e9ecef;
            border-color: var(--primary);
        }

        .file-input-container input[type="file"] {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .form-note {
            font-size: 14px;
            color: var(--gray);
            margin-top: 5px;
        }

        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
            text-decoration: none;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-success:hover {
            background: #218838;
            transform: translateY(-2px);
        }

        /* حالة فارغة */
        .empty-state {
            text-align: center;
            padding: 40px;
            color: var(--gray);
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 15px;
            color: #ddd;
        }

        .empty-state p {
            font-size: 18px;
            margin-bottom: 20px;
        }

        /* التكيف مع الشاشات الصغيرة */
        @media (max-width: 768px) {
            .top-nav {
                flex-direction: column;
                gap: 15px;
            }
            
            .nav-links {
                width: 100%;
                justify-content: center;
                flex-wrap: wrap;
            }
            
            .homework-header {
                flex-direction: column;
                gap: 10px;
            }
            
            .homework-meta {
                flex-direction: column;
                gap: 8px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- شريط التنقل العلوي -->
        <div class="top-nav">
            <div class="logo">
                <i class="fas fa-graduation-cap"></i>
                <span>اشراق</span>
            </div>
            
            <div class="nav-links">
                <a href="dashboard.php" class="nav-link">
                    <i class="fas fa-home"></i>
                    الرئيسية
                </a>
                <a href="lessons.php" class="nav-link">
                    <i class="fas fa-book-open"></i>
                    الدروس
                </a>
                <a href="homeworks.php" class="nav-link active">
                    <i class="fas fa-tasks"></i>
                    الواجبات
                </a>
                <a href="profile.php" class="nav-link">
                    <i class="fas fa-user"></i>
                    الملف الشخصي
                </a>
            </div>
        </div>

        <!-- رأس الصفحة -->
        <div class="page-header">
            <h1><i class="fas fa-tasks"></i> الواجبات</h1>
            <p>الصف: <strong><?php echo $class_name; ?></strong></p>
        </div>

        <!-- رسالة الحالة -->
        <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?php echo $success; ?>
            </div>
        <?php endif; ?>

        <!-- قائمة الواجبات -->
        <div class="homeworks-container">
            <?php if (count($homeworks) == 0): ?>
                <div class="empty-state">
                    <i class="fas fa-clipboard-list"></i>
                    <p>لا توجد واجبات مطلوبة حاليًا</p>
                    <a href="dashboard.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة إلى الرئيسية
                    </a>
                </div>
            <?php else: ?>
                <?php foreach ($homeworks as $hw): 
                    $now = new DateTime();
                    $due = $hw['due_date'] ? new DateTime($hw['due_date']) : null;
                    $is_overdue = $due && $now > $due;
                    $has_submitted = isset($submissions[$hw['id']]);
                    $submission = $has_submitted ? $submissions[$hw['id']] : null;
                    $comment_list = $has_submitted ? ($comments[$hw['id']] ?? []) : [];
                    
                    $status_class = $has_submitted ? 'status-submitted' : ($is_overdue ? 'status-overdue' : 'status-pending');
                    $status_text = $has_submitted ? 'مُسلّم' : ($is_overdue ? 'متأخر' : 'مطلوب');
                ?>
                    <div class="homework-card">
                        <div class="homework-header">
                            <div>
                                <h3 class="homework-title"><?php echo htmlspecialchars($hw['title']); ?></h3>
                                <p><strong>من:</strong> <?php echo htmlspecialchars($hw['teacher_name']); ?></p>
                            </div>
                            <span class="homework-status <?php echo $status_class; ?>">
                                <?php echo $status_text; ?>
                            </span>
                        </div>

                        <div class="homework-meta">
                            <?php if ($hw['due_date']): ?>
                                <div class="meta-item">
                                    <i class="fas fa-clock"></i>
                                    <span style="color: <?php echo $is_overdue ? 'red' : 'green'; ?>;">
                                        آخر موعد: <?php echo date('Y-m-d H:i', strtotime($hw['due_date'])); ?>
                                    </span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($hw['file_path']): ?>
                                <div class="meta-item">
                                    <i class="fas fa-file-download"></i>
                                    <a href="../assets/uploads/<?php echo $hw['file_path']; ?>" 
                                       target="_blank" 
                                       class="file-download">
                                        <i class="fas fa-download"></i> تحميل التعليمات
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if ($hw['description']): ?>
                            <div class="homework-description">
                                <strong>الوصف:</strong>
                                <p><?php echo nl2br(htmlspecialchars($hw['description'])); ?></p>
                            </div>
                        <?php endif; ?>

                        <!-- إذا سلّم: عرض التفاصيل والمحادثة -->
                        <?php if ($has_submitted): ?>
                            <div class="submission-section">
                                <h4 class="submission-header">
                                    <i class="fas fa-check-circle"></i> تم التسليم
                                </h4>
                                
                                <a href="../assets/uploads/<?php echo $submission['file_path']; ?>" 
                                   target="_blank" 
                                   class="file-download">
                                    <i class="fas fa-eye"></i> عرض الملف المرفق
                                </a>
                                
                                <?php if ($submission['note']): ?>
                                    <div class="submission-note">
                                        <strong>ملاحظتك:</strong>
                                        <p><?php echo nl2br(htmlspecialchars($submission['note'])); ?></p>
                                    </div>
                                <?php endif; ?>

                                <!-- سجل التعليقات -->
                                <div class="comments-section">
                                    <h4 class="comments-title">
                                        <i class="fas fa-comments"></i> المحادثة مع المُدرِّس
                                    </h4>
                                    
                                    <?php if (count($comment_list) > 0): ?>
                                        <div class="comments-container">
                                            <?php foreach ($comment_list as $c): 
                                                $is_student = $c['sender_type'] == 'student';
                                                $sender = $is_student ? 'أنت' : 'المُدرِّس';
                                                $sender_class = $is_student ? 'student' : 'teacher';
                                            ?>
                                                <div class="comment">
                                                    <div class="comment-header">
                                                        <span class="comment-sender"><?php echo $sender; ?></span>
                                                        <span class="comment-time"><?php echo date('H:i', strtotime($c['created_at'])); ?></span>
                                                    </div>
                                                    <p class="comment-message"><?php echo nl2br(htmlspecialchars($c['message'])); ?></p>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php else: ?>
                                        <p style="color: #777; text-align: center;">لا توجد تعليقات بعد</p>
                                    <?php endif; ?>

                                    <!-- نموذج الرد -->
                                    <form method="POST" class="comment-form">
                                        <input type="hidden" name="add_comment" value="1">
                                        <input type="hidden" name="homework_id" value="<?php echo $hw['id']; ?>">
                                        <textarea name="message" required placeholder="اكتب ردك..."></textarea>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-paper-plane"></i> إرسال الرد
                                        </button>
                                    </form>
                                </div>
                            </div>
                        <?php elseif (!$is_overdue): ?>
                            <!-- نموذج التسليم الأول -->
                            <form method="POST" enctype="multipart/form-data" class="submit-form">
                                <input type="hidden" name="submit_homework" value="1">
                                <input type="hidden" name="homework_id" value="<?php echo $hw['id']; ?>">
                                
                                <div class="form-group">
                                    <label class="form-label">رفع ملف الإجابة *</label>
                                    <div class="file-input-container">
                                        <div class="file-input-button">
                                            <i class="fas fa-cloud-upload-alt"></i>
                                            <span>اختر ملف الإجابة</span>
                                        </div>
                                        <input type="file" name="file" accept=".pdf,.jpg,.jpeg,.png,.doc,.docx" required>
                                    </div>
                                    <p class="form-note">الملفات المسموحة: PDF, JPG, PNG, DOC, DOCX</p>
                                </div>
                                
                                <div class="form-group">
                                    <label class="form-label">ملاحظة (اختياري)</label>
                                    <textarea name="note" class="form-input" rows="3" placeholder="ملاحظات على الإجابة..."></textarea>
                                </div>
                                
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-paper-plane"></i> تسليم الواجب
                                </button>
                            </form>
                        <?php else: ?>
                            <p style="color: #d9534f; font-weight: bold; text-align: center; padding: 15px;">
                                <i class="fas fa-clock"></i> انتهت مدة التسليم
                            </p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <script>
        // عرض اسم الملف عند اختياره
        document.querySelectorAll('input[type="file"]').forEach(input => {
            input.addEventListener('change', function(e) {
                const fileName = e.target.files[0]?.name || 'لم يتم اختيار ملف';
                const button = this.parentElement.querySelector('.file-input-button span');
                if (button) {
                    button.textContent = fileName;
                }
            });
        });
    </script>
</body>
</html>