<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isStudent()) {
    header("Location: ../index.php");
    exit();
}

$student = $_SESSION['user'];
$student_id = $student['id'];
$error = '';
$success = '';

// --- جلب اسم الصف ---
$classname = 'غير مرتبط بأي صف بعد';
$stmt = $pdo->prepare("SELECT c.name FROM classes c WHERE c.id = ?");
$stmt->execute([$student['class_id']]);
$class = $student['class_id'] ? $stmt->fetch() : null;
if ($class) {
    $classname = htmlspecialchars($class['name']);
}

// --- معالجة الحفظ ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);

    // التحقق من البريد إذا تغير
    if ($email !== $student['email']) {
        $check = $pdo->prepare("SELECT id FROM students WHERE email = ? AND id != ?");
        $check->execute([$email, $student_id]);
        if ($check->rowCount() > 0) {
            $error = "هذا البريد الإلكتروني مستخدم من قبل طالب آخر.";
        }
    }

    if (!$error) {
        $image_url = $student['image_url'];

        // رفع صورة جديدة إن وُجدت
        if (!empty($_FILES['image']['name'])) {
            $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];
            if (in_array(strtolower($ext), $allowed)) {
                $filename = 'uploads/' . uniqid() . '.' . $ext;
                $path = '../assets/' . $filename;

                if (move_uploaded_file($_FILES['image']['tmp_name'], $path)) {
                    // احذف الصورة القديمة إن لم تكن افتراضية
                    if ($image_url != 'uploads/default.png' && file_exists('../assets/' . $image_url)) {
                        unlink('../assets/' . $image_url);
                    }
                    $image_url = $filename;
                } else {
                    $error = "فشل رفع الصورة.";
                }
            } else {
                $error = "نوع الصورة غير مسموح به. فقط JPG، PNG، GIF.";
            }
        }

        if (!$error) {
            try {
                $stmt = $pdo->prepare("UPDATE students SET name = ?, email = ?, phone = ?, image_url = ? WHERE id = ?");
                $stmt->execute([$name, $email, $phone, $image_url, $student_id]);

                // تحديث الجلسة
                $_SESSION['user']['name'] = $name;
                $_SESSION['user']['email'] = $email;
                $_SESSION['user']['phone'] = $phone;
                $_SESSION['user']['image_url'] = $image_url;

                $success = "تم تحديث الملف الشخصي بنجاح!";
            } catch (Exception $e) {
                $error = "حدث خطأ أثناء الحفظ.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الملف الشخصي - اشراق</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #7209b7;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #2b2d42;
            --gray: #6c757d;
            --success: #4cc9f0;
            --error: #d9534f;
            --warning: #ffc107;
            --border-radius: 12px;
            --shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Cairo', sans-serif;
        }

        body {
            background: #f4f6f9;
            color: var(--dark);
            line-height: 1.6;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
        }

        /* شريط التنقل العلوي */
        .top-nav {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding: 15px 25px;
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 700;
            font-size: 20px;
            color: var(--primary);
        }

        .nav-links {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 15px;
            border-radius: var(--border-radius);
            color: var(--dark);
            text-decoration: none;
            transition: var(--transition);
        }

        .nav-link:hover {
            background: var(--light);
            color: var(--primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        /* رأس الصفحة */
        .page-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .page-header h1 {
            font-size: 32px;
            color: var(--primary);
            margin-bottom: 10px;
        }

        .page-header p {
            color: var(--gray);
            font-size: 18px;
        }

        /* محتوى الصفحة */
        .profile-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
        }

        @media (max-width: 768px) {
            .profile-content {
                grid-template-columns: 1fr;
            }
        }

        /* معلومات الطالب */
        .student-info-card {
            background: white;
            padding: 25px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            text-align: center;
        }

        .student-avatar {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            border: 4px solid var(--primary);
            object-fit: cover;
            margin: 0 auto 20px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .student-details {
            margin-top: 20px;
        }

        .detail-item {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #eee;
        }

        .detail-item:last-child {
            border-bottom: none;
        }

        .detail-label {
            font-weight: 600;
            color: var(--dark);
        }

        .detail-value {
            color: var(--gray);
        }

        .class-badge {
            background: var(--primary);
            color: white;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
        }

        /* نموذج التعديل */
        .edit-form-card {
            background: white;
            padding: 25px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
        }

        .form-title {
            font-size: 22px;
            color: var(--primary);
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f1f1f1;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
        }

        .form-input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 16px;
            transition: var(--transition);
        }

        .form-input:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }

        .file-input-container {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
            margin-top: 10px;
        }

        .file-input-button {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            padding: 12px;
            background: #f8f9fa;
            border: 2px dashed #ddd;
            border-radius: var(--border-radius);
            text-align: center;
            cursor: pointer;
            transition: var(--transition);
            width: 100%;
        }

        .file-input-button:hover {
            background: #e9ecef;
            border-color: var(--primary);
        }

        .file-input-container input[type="file"] {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .form-note {
            font-size: 14px;
            color: var(--gray);
            margin-top: 5px;
        }

        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 25px;
        }

        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
            text-decoration: none;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        /* رسائل الحالة */
        .alert {
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .alert-error {
            background: #ffebee;
            color: var(--error);
            border: 1px solid #f5c6cb;
        }

        .alert-success {
            background: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c3e6cb;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- شريط التنقل العلوي -->
        <div class="top-nav">
            <div class="logo">
                <i class="fas fa-graduation-cap"></i>
                <span>اشراق</span>
            </div>
            
            <div class="nav-links">
                <a href="dashboard.php" class="nav-link">
                    <i class="fas fa-home"></i>
                    الرئيسية
                </a>
                <a href="profile.php" class="nav-link active">
                    <i class="fas fa-user"></i>
                    الملف الشخصي
                </a>
                <a href="../logout.php" class="nav-link">
                    <i class="fas fa-sign-out-alt"></i>
                    تسجيل الخروج
                </a>
            </div>
        </div>

        <!-- رأس الصفحة -->
        <div class="page-header">
            <h1><i class="fas fa-user-cog"></i> الملف الشخصي</h1>
            <p>قم بتعديل معلوماتك الشخصية وصورتك</p>
        </div>

        <!-- رسالة الحالة -->
        <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?php echo $success; ?>
            </div>
        <?php endif; ?>

        <!-- محتوى الصفحة -->
        <div class="profile-content">
            <!-- معلومات الطالب -->
            <div class="student-info-card">
                <img src="../assets/<?php echo $student['image_url']; ?>" 
                     alt="صورة الطالب" 
                     class="student-avatar">
                
                <h2><?php echo htmlspecialchars($student['name']); ?></h2>
                <p class="class-badge"><?php echo $classname; ?></p>
                
                <div class="student-details">
                    <div class="detail-item">
                        <span class="detail-label">البريد الإلكتروني:</span>
                        <span class="detail-value"><?php echo htmlspecialchars($student['email']); ?></span>
                    </div>
                    
                    <div class="detail-item">
                        <span class="detail-label">رقم الهاتف:</span>
                        <span class="detail-value"><?php echo htmlspecialchars($student['phone'] ?? 'غير محدد'); ?></span>
                    </div>
                    
                    <div class="detail-item">
                        <span class="detail-label">حالة الحساب:</span>
                        <span class="detail-value" style="color: #28a745;">نشط</span>
                    </div>
                </div>
            </div>

            <!-- نموذج التعديل -->
            <div class="edit-form-card">
                <h3 class="form-title"><i class="fas fa-edit"></i> تعديل المعلومات</h3>
                
                <form method="POST" enctype="multipart/form-data">
                    <div class="form-group">
                        <label class="form-label">الاسم الكامل</label>
                        <input type="text" name="name" class="form-input" 
                               value="<?php echo htmlspecialchars($student['name']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-input" 
                               value="<?php echo htmlspecialchars($student['email']); ?>" required>
                    </div>

                    <div class="form-group">
                        <label class="form-label">رقم الهاتف</label>
                        <input type="text" name="phone" class="form-input" 
                               value="<?php echo htmlspecialchars($student['phone']); ?>">
                    </div>

                    <div class="form-group">
                        <label class="form-label">تغيير الصورة</label>
                        <div class="file-input-container">
                            <div class="file-input-button">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <span>اختر صورة جديدة</span>
                            </div>
                            <input type="file" name="image" accept="image/*">
                        </div>
                        <p class="form-note">الملفات المسموحة: JPG, PNG, GIF. الحجم الأقصى: 2MB</p>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> حفظ التغييرات
                        </button>
                        <a href="dashboard.php" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // عرض اسم الملف عند اختياره
        document.querySelector('input[type="file"]').addEventListener('change', function(e) {
            const fileName = e.target.files[0]?.name || 'لم يتم اختيار ملف';
            document.querySelector('.file-input-button span').textContent = fileName;
        });
    </script>
</body>
</html>