<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isTeacher()) {
    header("Location: ../index.php");
    exit();
}

$teacher_id = $_SESSION['user']['id'];
$error = '';
$success = '';

// --- حذف صف ---
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $class_id = $_GET['delete'];
    $stmt = $pdo->prepare("SELECT * FROM classes WHERE id = ? AND teacher_id = ?");
    $stmt->execute([$class_id, $teacher_id]);
    $class = $stmt->fetch();

    if (!$class) {
        $error = "الصف غير موجود أو ليس لك.";
    } else {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM students WHERE class_id = ?");
        $stmt->execute([$class_id]);
        $student_count = $stmt->fetchColumn();

        if ($student_count > 0) {
            $error = "لا يمكن حذف هذا الصف لأنه يحتوي على <strong>$student_count طالب</strong>.";
        } else {
            $stmt = $pdo->prepare("DELETE FROM classes WHERE id = ?");
            $stmt->execute([$class_id]);
            $success = "تم حذف الصف بنجاح!";
        }
    }
}

// --- إضافة صف جديد ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // إضافة صف
    if (isset($_POST['add_class'])) {
        $name = trim($_POST['name']);
        if (empty($name)) {
            $error = "اسم الصف مطلوب.";
        } else {
            $stmt = $pdo->prepare("SELECT id FROM classes WHERE name = ? AND teacher_id = ?");
            $stmt->execute([$name, $teacher_id]);
            if ($stmt->rowCount() > 0) {
                $error = "يوجد بالفعل صف باسم <strong>'$name'</strong>. الرجاء اختيار اسم مختلف.";
            } else {
                $stmt = $pdo->prepare("INSERT INTO classes (name, teacher_id) VALUES (?, ?)");
                $stmt->execute([$name, $teacher_id]);
                $success = "تم إضافة الصف <strong>'$name'</strong> بنجاح!";
            }
        }
    }

    // --- تعديل اسم الصف ---
    if (isset($_POST['edit_class_name'])) {
        $class_id = $_POST['class_id'];
        $new_name = trim($_POST['new_name']);

        if (empty($new_name)) {
            $error = "اسم الصف الجديد مطلوب.";
        } else {
            $stmt = $pdo->prepare("SELECT id FROM classes WHERE id = ? AND teacher_id = ?");
            $stmt->execute([$class_id, $teacher_id]);
            if ($stmt->rowCount() == 0) {
                $error = "غير مسموح لك تعديل هذا الصف.";
            } else {
                $stmt = $pdo->prepare("SELECT id FROM classes WHERE name = ? AND id != ? AND teacher_id = ?");
                $stmt->execute([$new_name, $class_id, $teacher_id]);
                if ($stmt->rowCount() > 0) {
                    $error = "يوجد بالفعل صف باسم <strong>'$new_name'</strong>.";
                } else {
                    $stmt = $pdo->prepare("UPDATE classes SET name = ? WHERE id = ?");
                    $stmt->execute([$new_name, $class_id]);
                    $success = "تم تحديث اسم الصف بنجاح!";
                }
            }
        }
    }

    // --- إزالة طالب من الصف ---
    if (isset($_POST['remove_student'])) {
        $student_id = $_POST['student_id'];
        $class_id = $_POST['class_id'];

        $stmt = $pdo->prepare("SELECT s.id FROM students s 
                               JOIN classes c ON s.class_id = c.id 
                               WHERE s.id = ? AND c.teacher_id = ?");
        $stmt->execute([$student_id, $teacher_id]);

        if ($stmt->rowCount() > 0) {
            $stmt = $pdo->prepare("UPDATE students SET class_id = NULL WHERE id = ?");
            $stmt->execute([$student_id]);
            $success = "تم إزالة الطالب من الصف.";
        } else {
            $error = "غير مسموح لك تعديل هذا الطالب.";
        }
    }
}

// --- جلب جميع الصفوف ---
$stmt = $pdo->prepare("SELECT * FROM classes WHERE teacher_id = ? ORDER BY name");
$stmt->execute([$teacher_id]);
$classes = $stmt->fetchAll();
?>

<?php include '../includes/header.php'; ?>

<div class="container">
    <h2>إدارة الصفوف</h2>

    <!-- رسائل الحالة -->
    <?php if ($error): ?>
        <div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 15px 0;">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 15px 0;">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>

    <!-- إضافة صف جديد -->
    <div style="background: #f0f8ff; padding: 25px; border-radius: 10px; border: 1px solid #b3d9ff; margin-bottom: 30px;">
        <h3 style="margin-top: 0; color: #007cba;">➕ إضافة صف جديد</h3>
        <form method="POST">
            <input type="hidden" name="add_class" value="1">
            <div style="margin-bottom: 15px; text-align: right;">
                <label style="display: block; margin-bottom: 6px; font-weight: 600;">اسم الصف</label>
                <input type="text" name="name" placeholder="مثل: الأول الثانوي - علمي" 
                       style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 6px; font-size: 16px;" required>
            </div>
            <button type="submit" style="padding: 10px 20px; background: #007cba; color: white; border: none; border-radius: 6px; cursor: pointer;">
                إضافة الصف
            </button>
        </form>
    </div>

    <!-- جدول الصفوف -->
    <h3>📚 الصفوف الحالية</h3>
    <?php if (count($classes) > 0): ?>
        <table style="width: 100%; border-collapse: collapse; direction: rtl; box-shadow: 0 1px 5px rgba(0,0,0,0.1);">
            <thead>
                <tr style="background: #007cba; color: white;">
                    <th style="padding: 12px; text-align: right; border-bottom: 2px solid #fff;">اسم الصف</th>
                    <th style="padding: 12px; text-align: center; border-bottom: 2px solid #fff;">عدد الطلاب</th>
                    <th style="padding: 12px; text-align: center; border-bottom: 2px solid #fff;">الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($classes as $class): ?>
                    <?php
                    $stmt = $pdo->prepare("SELECT id, name, email, phone FROM students WHERE class_id = ? ORDER BY name");
                    $stmt->execute([$class['id']]);
                    $students = $stmt->fetchAll();
                    $student_count = count($students);
                    ?>
                    <tr style="border-bottom: 1px solid #eee;">
                        <!-- تعديل اسم الصف بالنقر -->
                        <td style="padding: 12px; border: 1px solid #ddd;">
                            <a href="#" class="editClassName" 
                               data-class-id="<?php echo $class['id']; ?>" 
                               data-class-name="<?php echo htmlspecialchars($class['name']); ?>"
                               style="color: #007cba; text-decoration: none; font-weight: 600;">
                               ✏️ <?php echo htmlspecialchars($class['name']); ?>
                            </a>
                        </td>
                        <!-- عرض عدد الطلاب مع فتح Popup بالنقر -->
                        <td style="padding: 12px; text-align: center; border: 1px solid #ddd;">
                            <?php if ($student_count > 0): ?>
                                <a href="#" class="openStudentsModal" 
                                   data-class-id="<?php echo $class['id']; ?>"
                                   data-class-name="<?php echo htmlspecialchars($class['name']); ?>"
                                   data-students='<?php echo json_encode($students, JSON_UNESCAPED_UNICODE); ?>'
                                   style="color: #007cba; text-decoration: underline; cursor: pointer; font-weight: 600;">
                                    <?php echo $student_count; ?>
                                </a>
                            <?php else: ?>
                                <span style="color: #777;">0</span>
                            <?php endif; ?>
                        </td>
                        <!-- حذف الصف إن كان فارغًا -->
                        <td style="padding: 12px; text-align: center; border: 1px solid #ddd;">
                            <?php if ($student_count == 0): ?>
                                <a href="?delete=<?php echo $class['id']; ?>" 
                                   onclick="return confirm('هل أنت متأكد من حذف الصف: <?php echo addslashes($class['name']); ?>؟');"
                                   style="color: #d9534f; text-decoration: none; font-weight: bold;">
                                    حذف
                                </a>
                            <?php else: ?>
                                <span style="color: #777; font-size: 13px;">لا يمكن الحذف</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p style="text-align: right; color: #777; font-style: italic; margin: 20px 0;">
            لم تُضف أي صفوف بعد.
        </p>
    <?php endif; ?>

    <br>
    <a href="dashboard.php" class="btn" style="background: #6c757d; padding: 10px 20px; border-radius: 6px; text-decoration: none; color: white;">
        العودة للوحة التحكم
    </a>
</div>

<!-- 🎯 Popup: عرض الطلاب في الصف -->
<div id="studentsModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; justify-content: center; align-items: center;">
    <div style="background: white; width: 90%; max-width: 600px; border-radius: 10px; overflow: hidden; box-shadow: 0 5px 15px rgba(0,0,0,0.3);">
        <div style="background: #007cba; color: white; padding: 15px; text-align: right; font-size: 18px; font-weight: bold;" id="modalTitle">
            طلاب الصف
        </div>
        <div style="padding: 15px; background: #f8f9fa; border-bottom: 1px solid #ddd;">
            <input type="text" id="searchModal" placeholder="بحث عن طالب..." 
                   style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; font-size: 16px;">
        </div>
        <div id="modalStudentsList" style="max-height: 400px; overflow-y: auto; padding: 10px; text-align: right;">
            <!-- سيتم تعبئته بالـ JS -->
        </div>
        <div style="padding: 15px; text-align: left; border-top: 1px solid #ddd;">
            <button id="closeModal" style="padding: 8px 16px; background: #6c757d; color: white; border: none; border-radius: 5px; cursor: pointer;">
                إغلاق
            </button>
        </div>
    </div>
</div>

<!-- 🎯 Popup: تعديل اسم الصف -->
<div id="editClassModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; justify-content: center; align-items: center;">
    <div style="background: white; width: 90%; max-width: 500px; border-radius: 10px; padding: 20px; box-shadow: 0 5px 15px rgba(0,0,0,0.3);">
        <h4 style="margin-top: 0; color: #007cba;">تعديل اسم الصف</h4>
        <form id="editClassForm" method="POST">
            <input type="hidden" name="edit_class_name" value="1">
            <input type="hidden" name="class_id" id="editClassId">
            <div style="margin-bottom: 15px; text-align: right;">
                <label style="display: block; margin-bottom: 6px; font-weight: 600;">الاسم الجديد</label>
                <input type="text" name="new_name" id="editClassNameInput" required
                       style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 6px; font-size: 16px;">
            </div>
            <button type="submit" style="padding: 10px 20px; background: #007cba; color: white; border: none; border-radius: 6px; cursor: pointer;">
                تحديث
            </button>
            <button type="button" id="cancelEdit" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 6px; margin-right: 10px; cursor: pointer;">
                إلغاء
            </button>
        </form>
    </div>
</div>

<!-- 🧠 JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById('studentsModal');
    const editModal = document.getElementById('editClassModal');
    const modalTitle = document.getElementById('modalTitle');
    const modalList = document.getElementById('modalStudentsList');
    const searchInput = document.getElementById('searchModal');
    const closeModalBtn = document.getElementById('closeModal');
    const closeEditBtn = document.getElementById('cancelEdit');

    // --- فتح مودال الطلاب ---
    document.querySelectorAll('.openStudentsModal').forEach(link => {
        link.addEventListener('click', function (e) {
            e.preventDefault();
            const className = this.getAttribute('data-class-name');
            const students = JSON.parse(this.getAttribute('data-students'));
            const classId = this.getAttribute('data-class-id');

            modalTitle.textContent = `طلاب الصف: ${className}`;
            renderStudentList(students, classId);
            modal.style.display = 'flex';
        });
    });

    // --- فتح مودال تعديل اسم الصف ---
    document.querySelectorAll('.editClassName').forEach(link => {
        link.addEventListener('click', function (e) {
            e.preventDefault();
            const classId = this.getAttribute('data-class-id');
            const className = this.getAttribute('data-class-name');

            document.getElementById('editClassId').value = classId;
            document.getElementById('editClassNameInput').value = className;
            editModal.style.display = 'flex';
        });
    });

    // --- إغلاق المودالات ---
    closeModalBtn.addEventListener('click', () => modal.style.display = 'none');
    closeEditBtn.addEventListener('click', () => editModal.style.display = 'none');
    modal.addEventListener('click', e => { if (e.target === modal) modal.style.display = 'none'; });
    editModal.addEventListener('click', e => { if (e.target === editModal) editModal.style.display = 'none'; });

    // --- عرض الطلاب مع زر "إزالة" ---
    function renderStudentList(students, classId) {
        if (students.length === 0) {
            modalList.innerHTML = '<p style="text-align: center; color: #777;">لا يوجد طلاب في هذا الصف.</p>';
            return;
        }

        let html = '';
        students.forEach(student => {
            html += `
            <div class="student-item" style="padding: 10px; border-bottom: 1px solid #eee; margin-bottom: 5px;">
                <strong>${student.name}</strong><br>
                <small><b>البريد:</b> ${student.email}</small><br>
                <small><b>الهاتف:</b> ${student.phone || 'غير متوفر'}</small>
                <div style="margin-top: 5px;">
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="remove_student" value="1">
                        <input type="hidden" name="student_id" value="${student.id}">
                        <input type="hidden" name="class_id" value="${classId}">
                        <button type="submit" style="background: #d9534f; color: white; border: none; padding: 4px 8px; border-radius: 4px; font-size: 12px;"
                                onclick="return confirm('هل ترغب في إزالة هذا الطالب من الصف؟');">
                            إزالة
                        </button>
                    </form>
                </div>
            </div>`;
        });
        modalList.innerHTML = html;
    }

    // --- بحث داخل القائمة ---
    searchInput.addEventListener('input', function () {
        const filter = this.value.toLowerCase().trim();
        const items = modalList.querySelectorAll('.student-item');
        items.forEach(item => {
            const text = item.textContent.toLowerCase();
            item.style.display = text.includes(filter) ? 'block' : 'none';
        });
    });
});
</script>

<style>
/* تحسين التحويم على الروابط */
a.editClassName:hover, a.openStudentsModal:hover {
    text-decoration: underline !important;
}
</style>

<?php include '../includes/footer.php'; ?>