<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isTeacher()) {
    header("Location: ../index.php");
    exit();
}

$teacher_id = $_SESSION['user']['id'];
$error = '';
$success = '';

// --- جلب الصفوف ---
$stmt = $pdo->prepare("SELECT id, name FROM classes WHERE teacher_id = ?");
$stmt->execute([$teacher_id]);
$classes = $stmt->fetchAll();

// --- جلب الواجبات ---
$stmt = $pdo->prepare("SELECT h.*, c.name as class_name FROM homeworks h
                       JOIN classes c ON h.class_id = c.id
                       WHERE h.teacher_id = ?
                       ORDER BY h.due_date ASC, h.created_at DESC");
$stmt->execute([$teacher_id]);
$homeworks = $stmt->fetchAll();
?>

<?php include '../includes/header.php'; ?>

<div class="container">
    <h2>📬 واجباتي</h2>

    <?php if ($error): ?>
        <div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 15px 0;">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 15px 0;">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>

    <!-- أزرار سريعة -->
    <div style="margin-bottom: 20px; text-align: left;">
        <a href="add_homework.php" class="btn" style="background: #007cba;">➕ إنشاء واجب جديد</a>
    </div>

    <?php if (count($homeworks) == 0): ?>
        <p style="text-align: right; color: #777; padding: 30px; background: #f8f9fa; border-radius: 10px; font-style: italic;">
            لم تُنشئ أي واجب بعد.
        </p>
    <?php else: ?>
        <?php foreach ($homeworks as $hw): 
            // جلب عدد التسليمات
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM submissions s 
                                   JOIN students st ON s.student_id = st.id 
                                   WHERE s.homework_id = ? AND st.class_id = ?");
            $stmt->execute([$hw['id'], $hw['class_id']]);
            $submitted_count = $stmt->fetchColumn();

            // جلب عدد الطلاب في الصف
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM students WHERE class_id = ?");
            $stmt->execute([$hw['class_id']]);
            $total_students = $stmt->fetchColumn();
        ?>
            <div style="
                background: white;
                padding: 20px;
                border-radius: 12px;
                border: 1px solid #eee;
                margin-bottom: 20px;
                box-shadow: 0 2px 5px rgba(0,0,0,0.05);
                transition: transform 0.2s;
            " onmouseover="this.style.transform='translateY(-3px)';" onmouseout="this.style.transform='translateY(0)';">
                
                <!-- عنوان + حالة -->
                <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 12px;">
                    <h3 style="color: #007cba; margin: 0; font-size: 18px;"><?php echo htmlspecialchars($hw['title']); ?></h3>
                    <span style="
                        background: #6f42c1;
                        color: white;
                        padding: 6px 12px;
                        border-radius: 20px;
                        font-size: 12px;
                        font-weight: bold;
                    ">
                        الصف: <?php echo htmlspecialchars($hw['class_name']); ?>
                    </span>
                </div>

                <!-- التفاصيل -->
                <p style="margin: 6px 0; color: #555;"><strong>الوصف:</strong> <?php echo htmlspecialchars($hw['description'] ?: 'لا يوجد'); ?></p>
                
                <?php if ($hw['file_path']): ?>
                    <p style="margin: 6px 0; color: #555;">
                        <strong>ملف التعليمات:</strong> 
                        <a href="../assets/uploads/<?php echo $hw['file_path']; ?>" 
                           target="_blank" 
                           style="color: #007cba; text-decoration: underline;">تحميل</a>
                    </p>
                <?php endif; ?>

                <?php if ($hw['due_date']): ?>
                    <p style="margin: 6px 0; color: #555;">
                        <strong>آخر موعد:</strong> <?php echo date('Y-m-d H:i', strtotime($hw['due_date'])); ?>
                    </p>
                <?php endif; ?>

                <!-- إحصائيات التسليم -->
                <div style="margin: 15px 0; padding: 15px; background: #f8f9fa; border-radius: 8px; border: 1px solid #dee2e6;">
                    <strong>التسليمات:</strong>
                    <span style="color: #28a745;">
                        <?php echo $submitted_count; ?> / <?php echo $total_students; ?> طالب
                    </span>
                </div>

                <!-- أزرار الإجراءات -->
                <div style="display: flex; gap: 10px; margin-top: 15px;">
                    <a href="submissions.php?homework_id=<?php echo $hw['id']; ?>" 
                       class="btn" 
                       style="padding: 8px 16px; background: #007cba; font-size: 14px;">
                       عرض التسليمات (<?php echo $submitted_count; ?>)
                    </a>

                    <!-- حذف الواجب (فقط إذا لم يُسلّم أحد) -->
                    <?php if ($submitted_count == 0): ?>
                        <form method="POST" style="display: inline;" onsubmit="return confirm('هل أنت متأكد من حذف هذا الواجب؟');">
                            <input type="hidden" name="delete_homework" value="1">
                            <input type="hidden" name="homework_id" value="<?php echo $hw['id']; ?>">
                            <button type="submit" style="padding: 8px 16px; background: #d9534f; color: white; border: none; border-radius: 4px; font-size: 14px;">
                                حذف
                            </button>
                        </form>
                    <?php else: ?>
                        <span style="font-size: 12px; color: #777; padding: 8px;">لا يمكن الحذف (تم التسليم)</span>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <br>
    <a href="dashboard.php" class="btn" style="background: #6c757d;">العودة للوحة التحكم</a>
</div>

<!-- معالجة الحذف (اختياري: يمكنك نقلها لملف منفصل لاحقًا) -->
<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_homework'])) {
    $homework_id = $_POST['homework_id'];
    
    $stmt = $pdo->prepare("SELECT id FROM homeworks WHERE id = ? AND teacher_id = ?");
    $stmt->execute([$homework_id, $teacher_id]);
    if ($stmt->rowCount() > 0) {
        $stmt = $pdo->prepare("DELETE FROM homeworks WHERE id = ?");
        $stmt->execute([$homework_id]);
        echo "<script>location.href='homeworks.php';</script>";
    }
}
?>

<?php include '../includes/footer.php'; ?>