<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isTeacher()) {
    header("Location: ../index.php");
    exit();
}

$teacher_id = $_SESSION['user']['id'];

// --- جلب الإحصائيات مرة واحدة ---
$stmt = $pdo->prepare("
    SELECT 
        (SELECT COUNT(*) FROM classes WHERE teacher_id = ?) as total_classes,
        (SELECT COUNT(*) FROM students WHERE class_id IN (SELECT id FROM classes WHERE teacher_id = ?)) as total_students,
        (SELECT COUNT(*) FROM lessons WHERE teacher_id = ?) as total_lessons,
        (SELECT COUNT(*) FROM homeworks WHERE teacher_id = ?) as total_homeworks,
        (SELECT COUNT(*) FROM submissions WHERE homework_id IN (SELECT id FROM homeworks WHERE teacher_id = ?)) as total_submissions
");
$stmt->execute([$teacher_id, $teacher_id, $teacher_id, $teacher_id, $teacher_id]);
$stats = $stmt->fetch(PDO::FETCH_ASSOC);

// --- أحدث 5 دروس ---
$stmt = $pdo->prepare("SELECT l.*, c.name as class_name FROM lessons l 
                       LEFT JOIN classes c ON l.class_id = c.id 
                       WHERE l.teacher_id = ? 
                       ORDER BY l.start_time DESC, l.created_at DESC 
                       LIMIT 5");
$stmt->execute([$teacher_id]);
$recent_lessons = $stmt->fetchAll();

// --- أحدث 5 واجبات ---
$stmt = $pdo->prepare("SELECT h.*, c.name as class_name FROM homeworks h
                       LEFT JOIN classes c ON h.class_id = c.id
                       WHERE h.teacher_id = ?
                       ORDER BY h.due_date ASC, h.created_at DESC
                       LIMIT 5");
$stmt->execute([$teacher_id]);
$recent_homeworks = $stmt->fetchAll();

// --- الصفوف ---
$stmt = $pdo->prepare("SELECT * FROM classes WHERE teacher_id = ? ORDER BY name");
$stmt->execute([$teacher_id]);
$classes = $stmt->fetchAll();

// --- الدروس القادمة (live فقط) ---
$stmt = $pdo->prepare("SELECT l.title, l.start_time, c.name as class_name 
                       FROM lessons l
                       JOIN classes c ON l.class_id = c.id
                       WHERE l.teacher_id = ? AND l.lesson_type = 'live' AND l.start_time > NOW()
                       ORDER BY l.start_time ASC LIMIT 3");
$stmt->execute([$teacher_id]);
$upcoming_lessons = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة تحكم المدرّس</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #7209b7;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #2b2d42;
            --gray: #6c757d;
            --success: #28a745;
            --warning: #fd7e14;
            --info: #17a2b8;
            --border-radius: 12px;
            --shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            --transition: all 0.3s ease;
        }

        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding-top: 20px;
            padding-bottom: 40px;
        }
        
        .card {
            border: none;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            transition: var(--transition);
            margin-bottom: 20px;
            overflow: hidden;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }
        
        .card-icon {
            font-size: 2.2rem;
            opacity: 0.8;
            margin-bottom: 15px;
            transition: var(--transition);
        }
        
        .card:hover .card-icon {
            transform: scale(1.1);
        }
        
        .dashboard-title {
            border-bottom: 3px solid var(--primary);
            padding-bottom: 10px;
            margin-bottom: 30px;
            color: var(--dark);
            font-weight: 700;
        }
        
        .upcoming-card {
            border-right: 4px solid var(--success);
        }
        
        .lesson-item {
            border-right: 4px solid var(--primary);
            transition: var(--transition);
        }
        
        .lesson-item:hover {
            background-color: rgba(67, 97, 238, 0.05);
        }
        
        .homework-item {
            border-right: 4px solid var(--warning);
            transition: var(--transition);
        }
        
        .homework-item:hover {
            background-color: rgba(253, 126, 20, 0.05);
        }
        
        .stat-number {
            font-size: 2.2rem;
            font-weight: 700;
            margin: 10px 0;
            color: var(--dark);
        }
        
        .btn {
            border-radius: var(--border-radius);
            padding: 8px 16px;
            font-weight: 600;
            transition: var(--transition);
        }
        
        .btn-sm {
            padding: 5px 12px;
            font-size: 0.875rem;
        }
        
        .list-group-item {
            border-radius: var(--border-radius);
            margin-bottom: 10px;
            border: 1px solid rgba(0,0,0,0.08);
            transition: var(--transition);
        }
        
        .list-group-item:hover {
            box-shadow: var(--shadow);
        }
        
        .badge {
            font-weight: 500;
            border-radius: 30px;
            padding: 6px 10px;
        }
        
        /* تحسينات للهاتف */
        @media (max-width: 768px) {
            .dashboard-title {
                font-size: 1.8rem;
            }
            
            .stat-number {
                font-size: 1.8rem;
            }
            
            .card-icon {
                font-size: 1.8rem;
            }
            
            .card-body {
                padding: 15px;
            }
            
            .btn-group-responsive {
                display: flex;
                flex-direction: column;
                gap: 10px;
            }
            
            .btn-group-responsive .btn {
                width: 100%;
                margin-bottom: 5px;
            }
            
            .header-actions {
                display: flex;
                flex-wrap: wrap;
                gap: 10px;
                margin-top: 15px;
            }
        }
        
        /* تحسينات للكمبيوتر اللوحي */
        @media (min-width: 769px) and (max-width: 1024px) {
            .stat-number {
                font-size: 1.8rem;
            }
            
            .card-icon {
                font-size: 1.8rem;
            }
        }
        
        /* تحسينات التخصيص */
        .bg-custom-primary {
            background-color: var(--primary);
            color: white;
        }
        
        .bg-custom-success {
            background-color: var(--success);
            color: white;
        }
        
        .bg-custom-warning {
            background-color: var(--warning);
            color: white;
        }
        
        .bg-custom-info {
            background-color: var(--info);
            color: white;
        }
        
        .text-custom-primary {
            color: var(--primary);
        }
        
        .text-custom-success {
            color: var(--success);
        }
        
        .text-custom-warning {
            color: var(--warning);
        }
        
        .text-custom-info {
            color: var(--info);
        }
        
        .quick-action-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 15px 10px;
            border-radius: var(--border-radius);
            background: white;
            box-shadow: var(--shadow);
            transition: var(--transition);
            text-align: center;
            color: var(--dark);
            text-decoration: none;
        }
        
        .quick-action-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
            color: var(--primary);
        }
        
        .quick-action-btn i {
            font-size: 1.8rem;
            margin-bottom: 10px;
            color: var(--primary);
        }
        
        .mobile-bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            z-index: 1000;
            display: none;
        }
        
        .mobile-nav-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: var(--gray);
            font-size: 0.8rem;
            transition: var(--transition);
        }
        
        .mobile-nav-btn i {
            font-size: 1.2rem;
            margin-bottom: 5px;
        }
        
        .mobile-nav-btn.active {
            color: var(--primary);
        }
        
        @media (max-width: 768px) {
            .mobile-bottom-nav {
                display: flex;
            }
            
            body {
                padding-bottom: 70px;
            }
            
            .container {
                margin-bottom: 20px;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container py-4">
        <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap">
            <h1 class="dashboard-title">
            مرحباً <span class="text-custom-primary"><?php echo htmlspecialchars($_SESSION['user']['name']); ?></span> 
            </h1>
            <div class="header-actions">
                <a href="settings.php" class="btn btn-outline-secondary btn-sm">
                    <i class="bi bi-gear"></i> الإعدادات
                </a>
                <a href="logout.php" class="btn btn-danger btn-sm">
                    <i class="bi bi-box-arrow-right"></i> تسجيل الخروج
                </a>
            </div>
        </div>

        <!-- الإحصائيات -->
        <div class="row g-4 mb-4">
            <div class="col-6 col-md-6 col-lg-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="bi bi-journal-text card-icon text-custom-primary"></i>
                        <h5 class="card-title text-custom-primary">الصفوف</h5>
                        <p class="stat-number"><?php echo $stats['total_classes']; ?></p>
                        <a href="add_class.php" class="btn btn-sm btn-outline-primary">+ إضافة صف</a>
                    </div>
                </div>
            </div>

            <div class="col-6 col-md-6 col-lg-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="bi bi-people card-icon text-custom-success"></i>
                        <h5 class="card-title text-custom-success">الطلاب</h5>
                        <p class="stat-number"><?php echo $stats['total_students']; ?></p>
                        <a href="manage_students.php" class="btn btn-sm btn-outline-success">إدارة الطلاب</a>
                    </div>
                </div>
            </div>

            <div class="col-6 col-md-6 col-lg-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="bi bi-play-btn card-icon text-custom-warning"></i>
                        <h5 class="card-title text-custom-warning">الدروس</h5>
                        <p class="stat-number"><?php echo $stats['total_lessons']; ?></p>
                        <a href="add_lesson.php" class="btn btn-sm btn-outline-warning">+ إضافة درس</a>
                    </div>
                </div>
            </div>

            <div class="col-6 col-md-6 col-lg-3">
                <div class="card text-center h-100">
                    <div class="card-body">
                        <i class="bi bi-clipboard-check card-icon text-custom-info"></i>
                        <h5 class="card-title text-custom-info">الواجبات</h5>
                        <p class="stat-number"><?php echo $stats['total_homeworks']; ?></p>
                        <a href="add_homework.php" class="btn btn-sm btn-outline-info">+ إضافة واجب</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- إجراءات سريعة للهاتف -->
        <div class="row g-3 mb-4 d-md-none">
            <div class="col-6">
                <a href="add_lesson.php" class="quick-action-btn">
                    <i class="bi bi-plus-circle"></i>
                    <span>إضافة درس</span>
                </a>
            </div>
            <div class="col-6">
                <a href="add_homework.php" class="quick-action-btn">
                    <i class="bi bi-file-earmark-plus"></i>
                    <span>إضافة واجب</span>
                </a>
            </div>
            <div class="col-6">
                <a href="manage_students.php" class="quick-action-btn">
                    <i class="bi bi-people"></i>
                    <span>إدارة الطلاب</span>
                </a>
            </div>
            <div class="col-6">
                <a href="add_class.php" class="quick-action-btn">
                    <i class="bi bi-journal-plus"></i>
                    <span>إضافة صف</span>
                </a>
            </div>
        </div>

        <!-- أحدث الدروس -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="bi bi-calendar-event text-custom-primary"></i> أحدث الدروس</h5>
                        <a href="add_lesson.php" class="btn btn-sm btn-outline-primary">إضافة</a>
                    </div>
                    <div class="card-body">
                        <?php if ($recent_lessons): ?>
                            <div class="list-group list-group-flush">
                                <?php foreach ($recent_lessons as $lesson): ?>
                                    <div class="list-group-item lesson-item p-3">
                                        <div class="d-flex justify-content-between align-items-center flex-column flex-md-row">
                                            <div class="mb-2 mb-md-0">
                                                <strong class="d-block"><?php echo htmlspecialchars($lesson['title'] ?: 'بدون عنوان'); ?></strong>
                                                <div class="text-muted small mt-1">
                                                    الصف: <?php echo htmlspecialchars($lesson['class_name']); ?> |
                                                    نوع: <span class="badge bg-<?php echo $lesson['lesson_type'] == 'live' ? 'primary' : 'secondary'; ?>">
                                                        <?php echo $lesson['lesson_type'] == 'live' ? 'مباشر' : 'مسجل'; ?>
                                                    </span>
                                                    <?php if ($lesson['start_time']): ?>
                                                        | وقت: <?php echo date('Y-m-d H:i', strtotime($lesson['start_time'])); ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="btn-group-responsive mt-2 mt-md-0">
                                                <?php if ($lesson['lesson_type'] == 'live' && $lesson['zoom_link']): ?>
                                                    <a href="<?php echo htmlspecialchars($lesson['zoom_link']); ?>" target="_blank"
                                                       class="btn btn-sm btn-success mb-1 mb-md-0">مشاهدة البث المباشر</a>
                                                <?php elseif ($lesson['recorded_link']): ?>
                                                    <a href="<?php echo htmlspecialchars($lesson['recorded_link']); ?>" target="_blank"
                                                       class="btn btn-sm btn-secondary mb-1 mb-md-0">مشاهدة</a>
                                                <?php endif; ?>
                                                <a href="add_lesson.php?edit=<?php echo $lesson['id']; ?>"
                                                   class="btn btn-sm btn-outline-warning">تعديل</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-center text-muted py-3">لم تُضف أي دروس بعد.</p>
                            <div class="text-center">
                                <a href="add_lesson.php" class="btn btn-primary">أضف أول درس</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- أحدث الواجبات -->
                <div class="card">
                    <div class="card-header bg-light d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="bi bi-file-earmark-text text-custom-warning"></i> أحدث الواجبات</h5>
                        <a href="add_homework.php" class="btn btn-sm btn-outline-warning">إضافة</a>
                    </div>
                    <div class="card-body">
                        <?php if ($recent_homeworks): ?>
                            <div class="list-group list-group-flush">
                                <?php foreach ($recent_homeworks as $hw): ?>
                                    <div class="list-group-item homework-item p-3">
                                        <div class="d-flex justify-content-between align-items-center flex-column flex-md-row">
                                            <div class="mb-2 mb-md-0">
                                                <strong class="d-block"><?php echo htmlspecialchars($hw['title']); ?></strong>
                                                <div class="text-muted small mt-1">
                                                    الصف: <?php echo htmlspecialchars($hw['class_name']); ?> |
                                                    موعد التسليم: <?php echo $hw['due_date'] ? date('Y-m-d H:i', strtotime($hw['due_date'])) : 'غير محدد'; ?>
                                                </div>
                                            </div>
                                            <div class="mt-2 mt-md-0">
                                                <a href="view_homework.php?id=<?php echo $hw['id']; ?>" 
                                                   class="btn btn-sm btn-outline-info">التفاصيل</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-center text-muted py-3">لم تُضف أي واجبات بعد.</p>
                            <div class="text-center">
                                <a href="add_homework.php" class="btn btn-warning">أضف أول واجب</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- العمود الجانبي -->
            <div class="col-lg-4">
                <!-- الدروس القادمة -->
                <div class="card upcoming-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-clock-history text-custom-success"></i> الدروس القادمة</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($upcoming_lessons): ?>
                            <div class="list-group">
                                <?php foreach ($upcoming_lessons as $lesson): ?>
                                    <div class="list-group-item p-3">
                                        <strong class="d-block"><?php echo htmlspecialchars($lesson['title']); ?></strong>
                                        <div class="text-muted small mt-1">
                                            الصف: <?php echo htmlspecialchars($lesson['class_name']); ?><br>
                                            <?php echo date('Y-m-d H:i', strtotime($lesson['start_time'])); ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-muted text-center py-3">لا توجد دروس قادمة.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- الصفوف -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-bookshelf text-custom-primary"></i> صفوفك</h5>
                    </div>
                    <div class="card-body">
                        <?php if ($classes): ?>
                            <div class="list-group">
                                <?php foreach ($classes as $c): ?>
                                    <div class="list-group-item p-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <span><?php echo htmlspecialchars($c['name']); ?></span>
                                            <span class="badge bg-primary">
                                                <?php
                                                $stmt = $pdo->prepare("SELECT COUNT(*) FROM students WHERE class_id = ?");
                                                $stmt->execute([$c['id']]);
                                                echo $stmt->fetchColumn();
                                                ?> طالب
                                            </span>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <p class="text-muted text-center py-3">لم تُضف أي صفوف بعد.</p>
                            <div class="text-center">
                                <a href="add_class.php" class="btn btn-sm btn-outline-primary">+ إضافة صف</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- شريط التنقل السفلي للهاتف -->
    <nav class="mobile-bottom-nav">
        <a href="dashboard.php" class="mobile-nav-btn active">
            <i class="bi bi-house"></i>
            <span>الرئيسية</span>
        </a>
        <a href="add_lesson.php" class="mobile-nav-btn">
            <i class="bi bi-plus-circle"></i>
            <span>إضافة</span>
        </a>
        <a href="manage_students.php" class="mobile-nav-btn">
            <i class="bi bi-people"></i>
            <span>الطلاب</span>
        </a>
        <a href="settings.php" class="mobile-nav-btn">
            <i class="bi bi-gear"></i>
            <span>الإعدادات</span>
        </a>
    </nav>

    <?php include '../includes/footer.php'; ?>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // إضافة تأثيرات تفاعلية
        document.addEventListener('DOMContentLoaded', function() {
            // تأثيرات للبطاقات عند التمرير
            const cards = document.querySelectorAll('.card');
            cards.forEach(card => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            });
            
            // تأثير الظهور التدريجي للبطاقات
            setTimeout(() => {
                cards.forEach((card, index) => {
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, index * 100);
                });
            }, 300);
            
            // إضافة فعالية للأزرار في القائمة السفلية
            const navButtons = document.querySelectorAll('.mobile-nav-btn');
            navButtons.forEach(button => {
                button.addEventListener('click', function() {
                    navButtons.forEach(btn => btn.classList.remove('active'));
                    this.classList.add('active');
                });
            });
        });
    </script>
</body>
</html>