<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isTeacher()) {
    header("Location: ../index.php");
    exit();
}

$teacher_id = $_SESSION['user']['id'];
$success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $open = $_POST['registration_open'] ? 1 : 0;
    $stmt = $pdo->prepare("INSERT INTO settings (registration_open, teacher_id) VALUES (?, ?) 
                           ON DUPLICATE KEY UPDATE registration_open = ?");
    $stmt->execute([$open, $teacher_id, $open]);
    $success = "تم تحديث إعدادات التسجيل.";
}

// جلب الإعدادات الحالية
$stmt = $pdo->prepare("SELECT registration_open FROM settings WHERE teacher_id = ?");
$stmt->execute([$teacher_id]);
$setting = $stmt->fetch();
$open = $setting ? (bool)$setting['registration_open'] : true;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعدادات التسجيل - منصة التعليم</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #7209b7;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #2b2d42;
            --gray: #6c757d;
            --success: #4cc9f0;
            --error: #d9534f;
            --warning: #ffc107;
            --border-radius: 12px;
            --shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Cairo', sans-serif;
        }

        body {
            background: #f4f6f9;
            color: var(--dark);
            line-height: 1.6;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            flex: 1;
        }

        /* رأس الصفحة */
        .page-header {
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            padding: 25px;
            border-radius: var(--border-radius);
            margin-bottom: 30px;
            box-shadow: var(--shadow);
            text-align: center;
        }

        .page-header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }

        /* رسائل الحالة */
        .alert {
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .alert-error {
            background: #ffebee;
            color: var(--error);
            border: 1px solid #f5c6cb;
        }

        .alert-success {
            background: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c3e6cb;
        }

        /* إعدادات التسجيل */
        .settings-container {
            background: white;
            padding: 30px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            margin-bottom: 30px;
        }

        .settings-title {
            font-size: 24px;
            color: var(--primary);
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f1f1f1;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .settings-form {
            max-width: 600px;
        }

        .toggle-group {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 30px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: var(--border-radius);
            border: 1px solid #e9ecef;
        }

        .toggle-label {
            font-size: 18px;
            font-weight: 600;
            color: var(--dark);
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        /* تصميم Toggle Switch */
        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 30px;
        }

        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: var(--transition);
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 22px;
            width: 22px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: var(--transition);
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: var(--success);
        }

        input:checked + .slider:before {
            transform: translateX(30px);
        }

        .status-indicator {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            margin-right: 10px;
        }

        .status-open {
            background: rgba(76, 201, 240, 0.1);
            color: var(--success);
        }

        .status-closed {
            background: rgba(217, 83, 79, 0.1);
            color: var(--error);
        }

        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 30px;
            flex-wrap: wrap;
        }

        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        /* معلومات إضافية */
        .info-box {
            background: #e8f4fc;
            padding: 20px;
            border-radius: var(--border-radius);
            border-left: 4px solid var(--primary);
            margin-top: 30px;
        }

        .info-title {
            font-size: 18px;
            color: var(--primary);
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .info-content {
            color: var(--dark);
            line-height: 1.6;
        }

        .info-list {
            margin: 10px 0;
            padding-right: 20px;
        }

        .info-list li {
            margin-bottom: 8px;
        }

        /* التكيف مع الشاشات الصغيرة */
        @media (max-width: 768px) {
            .toggle-group {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .form-actions {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container">
        <!-- رأس الصفحة -->
        <div class="page-header">
            <h1>
                <i class="fas fa-cog"></i>
                إعدادات التسجيل
            </h1>
            <p>إدارة إعدادات تسجيل الطلاب الجدد في المنصة</p>
        </div>

        <!-- رسالة الحالة -->
        <?php if ($success): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?php echo $success; ?>
            </div>
        <?php endif; ?>

        <!-- إعدادات التسجيل -->
        <div class="settings-container">
            <h2 class="settings-title">
                <i class="fas fa-user-plus"></i>
                حالة التسجيل
            </h2>
            
            <form method="POST" class="settings-form">
                <div class="toggle-group">
                    <label class="toggle-switch">
                        <input type="checkbox" name="registration_open" <?php if ($open) echo 'checked'; ?>>
                        <span class="slider"></span>
                    </label>
                    
                    <label class="toggle-label">
                        <i class="fas fa-user-graduate"></i>
                        السماح للطلاب الجدد بالتسجيل
                    </label>
                    
                    <span class="status-indicator <?php echo $open ? 'status-open' : 'status-closed'; ?>">
                        <i class="fas <?php echo $open ? 'fa-check-circle' : 'fa-times-circle'; ?>"></i>
                        <?php echo $open ? 'مفتوح' : 'مغلق'; ?>
                    </span>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        حفظ الإعدادات
                    </button>
                    <a href="dashboard.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i>
                        العودة للوحة التحكم
                    </a>
                </div>
            </form>
        </div>

        <!-- معلومات إضافية -->
        <div class="info-box">
            <h3 class="info-title">
                <i class="fas fa-info-circle"></i>
                معلومات مهمة
            </h3>
            <div class="info-content">
                <p>هذه الإعدادات تتحكم في قدرة الطلاب الجدد على التسجيل في المنصة:</p>
                <ul class="info-list">
                    <li><strong>مفتوح:</strong> يمكن للطلاب الجدد إنشاء حسابات جديدة والتسجيل في المنصة.</li>
                    <li><strong>مغلق:</strong> لا يمكن إنشاء حسابات جديدة، لكن الطلاب الحاليين يمكنهم تسجيل الدخول بشكل طبيعي.</li>
                    <li>يؤثر إغلاق التسجيل على صفحة تسجيل الطلاب فقط ولا يؤثر على وظائف المنصة الأخرى.</li>
                    <li>يمكنك فتح التسجيل مؤقتاً للفصول الدراسية الجديدة ثم إغلاقه مرة أخرى.</li>
                </ul>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>

    <script>
    // تأثير تغيير حالة التبديل
    const toggleSwitch = document.querySelector('.toggle-switch input');
    const statusIndicator = document.querySelector('.status-indicator');
    
    toggleSwitch.addEventListener('change', function() {
        if (this.checked) {
            statusIndicator.innerHTML = '<i class="fas fa-check-circle"></i> مفتوح';
            statusIndicator.className = 'status-indicator status-open';
        } else {
            statusIndicator.innerHTML = '<i class="fas fa-times-circle"></i> مغلق';
            statusIndicator.className = 'status-indicator status-closed';
        }
    });

    // تأثيرات عند التحميل
    document.addEventListener('DOMContentLoaded', function() {
        const settingsContainer = document.querySelector('.settings-container');
        settingsContainer.style.animation = 'fadeIn 0.5s ease-in-out';
    });
    </script>
</body>
</html>