<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isTeacher()) {
    header("Location: ../index.php");
    exit();
}

$teacher_id = $_SESSION['user']['id'];
$homework_id = $_GET['homework_id'] ?? null;
$student_name = $_GET['student_name'] ?? '';

// --- التحقق من وجود الواجب ---
if (!$homework_id) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>الرجاء تحديد واجب.</h3>");
}

$stmt = $pdo->prepare("SELECT h.*, c.name as class_name FROM homeworks h
                       JOIN classes c ON h.class_id = c.id
                       WHERE h.id = ? AND h.teacher_id = ?");
$stmt->execute([$homework_id, $teacher_id]);
$homework = $stmt->fetch();

if (!$homework) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>غير مسموح لك عرض هذا الواجب.</h3>");
}

// --- جلب جميع الطلاب في الصف ---
$stmt = $pdo->prepare("SELECT id, name, email FROM students WHERE class_id = ? ORDER BY name");
$stmt->execute([$homework['class_id']]);
$students = $stmt->fetchAll();

// --- جلب التسليمات ---
$stmt = $pdo->prepare("SELECT student_id FROM submissions WHERE homework_id = ?");
$stmt->execute([$homework_id]);
$submitted_ids = [];
while ($row = $stmt->fetch()) {
    $submitted_ids[] = $row['student_id'];
}

// --- تصفية حسب اسم الطالب إن وُجد ---
if (!empty($student_name)) {
    $students = array_filter($students, function ($s) use ($student_name) {
        return stripos($s['name'], $student_name) !== false;
    });
}
?>

<?php include '../includes/header.php'; ?>

<div class="container">
    <h2>📤 تسليمات: <?php echo htmlspecialchars($homework['title']); ?></h2>
    <p style="color: #555; margin-bottom: 20px;">
        <strong>الصف:</strong> <?php echo htmlspecialchars($homework['class_name']); ?> |
        <strong>الموعد:</strong> 
        <?php echo $homework['due_date'] ? date('Y-m-d H:i', strtotime($homework['due_date'])) : 'غير محدد'; ?>
    </p>

    <!-- بحث في اسم الطالب -->
    <div style="margin-bottom: 20px; text-align: right;">
        <input type="text" id="searchStudent" 
               value="<?php echo htmlspecialchars($student_name); ?>" 
               placeholder="🔎 ابحث عن طالب..." 
               style="width: 100%; max-width: 300px; padding: 10px; border: 1px solid #ccc; border-radius: 6px; font-size: 16px;">
    </div>

    <!-- إحصائيات -->
    <?php
    $total = count($students);
    $submitted_count = 0;
    foreach ($students as $s) {
        if (in_array($s['id'], $submitted_ids)) $submitted_count++;
    }
    ?>
    <div style="display: flex; gap: 15px; margin-bottom: 20px; font-size: 14px;">
        <div style="padding: 10px 15px; background: #d4edda; border-radius: 6px; color: #155724;">
            <strong>سلّموا:</strong> <?php echo $submitted_count; ?>
        </div>
        <div style="padding: 10px 15px; background: #f8d7da; border-radius: 6px; color: #721c24;">
            <strong>لم يُسلّموا:</strong> <?php echo $total - $submitted_count; ?>
        </div>
        <div style="padding: 10px 15px; background: #f8f9fa; border-radius: 6px; color: #495057;">
            <strong>إجمالي:</strong> <?php echo $total; ?>
        </div>
    </div>

    <!-- جدول الطلاب -->
    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; direction: rtl;">
            <thead>
                <tr style="background: #007cba; color: white;">
                    <th style="padding: 12px; text-align: right;">الاسم</th>
                    <th style="padding: 12px; text-align: right;">البريد</th>
                    <th style="padding: 12px; text-align: center;">الحالة</th>
                    <th style="padding: 12px; text-align: center;">الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $s): 
                    $has_submitted = in_array($s['id'], $submitted_ids);
                ?>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 12px; border: 1px solid #ddd; 
                                   color: <?php echo $has_submitted ? 'inherit' : 'red'; ?>;
                                   font-weight: <?php echo $has_submitted ? 'normal' : 'bold'; ?>;">
                            <?php echo htmlspecialchars($s['name']); ?>
                        </td>
                        <td style="padding: 12px; border: 1px solid #ddd; 
                                   color: <?php echo $has_submitted ? 'inherit' : 'red'; ?>;">
                            <?php echo htmlspecialchars($s['email']); ?>
                        </td>
                        <td style="padding: 12px; text-align: center; border: 1px solid #ddd;">
                            <span style="
                                color: <?php echo $has_submitted ? '#155724' : '#721c24'; ?>;
                                background: <?php echo $has_submitted ? '#d4edda' : '#f8d7da'; ?>;
                                padding: 6px 12px;
                                border-radius: 20px;
                                font-size: 12px;
                                font-weight: bold;
                            ">
                                <?php echo $has_submitted ? 'مُسلّم' : 'لم يُسلّم'; ?>
                            </span>
                        </td>
                        <td style="padding: 12px; text-align: center; border: 1px solid #ddd;">
                            <?php if ($has_submitted): ?>
                                <!-- إذا سلّم: عرض التسليم -->
                                <a href="view_submission.php?homework_id=<?php echo $homework_id; ?>&student_id=<?php echo $s['id']; ?>"
                                   style="padding: 6px 12px; background: #007cba; color: white; text-decoration: none; border-radius: 4px; font-size: 12px;">
                                   عرض
                                </a>
                            <?php else: ?>
                                <!-- إذا لم يُسلّم: لا يمكن فعل شيء (أو تذكير لاحقًا) -->
                                <span style="color: #777; font-size: 12px;">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <?php if (count($students) == 0): ?>
        <p style="text-align: right; color: #777; margin: 20px 0;">لا يوجد طلاب في هذا الصف بعد.</p>
    <?php endif; ?>

    <br>
    <a href="homeworks.php" class="btn" style="background: #6c757d;">العودة للواجبات</a>
</div>

<!-- JavaScript: بحث فوري -->
<script>
document.getElementById('searchStudent').addEventListener('input', function () {
    const filter = this.value.toLowerCase().trim();
    const rows = document.querySelectorAll('tbody tr');

    rows.forEach(row => {
        const name = row.cells[0].textContent.toLowerCase();
        const email = row.cells[1].textContent.toLowerCase();
        if (name.includes(filter) || email.includes(filter)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});
</script>

<?php include '../includes/footer.php'; ?>