<?php
// upload_file.php - معالج رفع الملفات

session_start();
require_once '../includes/db.php';

// ✅ التحقق من وجود جلسة المستخدم (بدون الاعتماد على 'role')
if (!isset($_SESSION['user']) || !isset($_SESSION['user']['id'])) {
    echo json_encode(['error' => 'غير مصرح بالوصول']);
    exit();
}

// التحقق من وجود ملف
if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['error' => 'لم يتم اختيار ملف أو حدث خطأ أثناء الرفع.']);
    exit();
}

$file = $_FILES['file'];

// التحقق من نوع الملف
$allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'application/pdf'];
if (!in_array($file['type'], $allowed_types)) {
    echo json_encode(['error' => 'نوع الملف غير مدعوم. يُسمح فقط بـ: صور (JPG, PNG, GIF) و PDF.']);
    exit();
}

// التحقق من الحجم (50MB كحد أقصى)
$max_size = 50 * 1024 * 1024;
if ($file['size'] > $max_size) {
    echo json_encode(['error' => 'حجم الملف كبير جدًا. الحد الأقصى: 50 ميجابايت.']);
    exit();
}

// إنشاء مجلد uploads إذا لم يكن موجودًا
$upload_dir = '../uploads/';
if (!is_dir($upload_dir)) {
    if (!mkdir($upload_dir, 0755, true)) {
        echo json_encode(['error' => 'فشل في إنشاء مجلد الرفع.']);
        exit();
    }
}

// توليد اسم فريد للملف
$file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
$filename = uniqid() . '.' . strtolower($file_extension);
$filepath = $upload_dir . $filename;

// رفع الملف
if (!move_uploaded_file($file['tmp_name'], $filepath)) {
    echo json_encode(['error' => 'فشل في حفظ الملف على السيرفر.']);
    exit();
}

// تحديد نوع الملف
$file_type = 'other';
if (in_array($file['type'], ['image/jpeg', 'image/png', 'image/gif'])) {
    $file_type = 'image';
} elseif ($file['type'] == 'application/pdf') {
    $file_type = 'pdf';
}

// إرجاع النجاح مع مسار الملف
echo json_encode([
    'success' => true,
    'file_path' => str_replace('../', '', $filepath),
    'file_type' => $file_type
]);
?>