<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isTeacher()) {
    header("Location: ../index.php");
    exit();
}

$teacher_id = $_SESSION['user']['id'];

// --- دعم كلا الشكلين: ?id= أو ?homework_id= ---
$homework_id = $_GET['homework_id'] ?? $_GET['id'] ?? null;

if (!$homework_id) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>الرجاء تحديد واجب.</h3>");
}

// --- جلب تفاصيل الواجب ---
$stmt = $pdo->prepare("SELECT h.*, c.name as class_name FROM homeworks h
                       JOIN classes c ON h.class_id = c.id
                       WHERE h.id = ? AND h.teacher_id = ?");
$stmt->execute([$homework_id, $teacher_id]);
$homework = $stmt->fetch();

if (!$homework) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>غير مسموح لك عرض هذا الواجب أو الواجب غير موجود.</h3>");
}

// --- جلب عدد التسليمات ---
$stmt = $pdo->prepare("SELECT COUNT(*) FROM submissions WHERE homework_id = ?");
$stmt->execute([$homework_id]);
$submitted_count = $stmt->fetchColumn();

// --- جلب عدد الطلاب في الصف ---
$stmt = $pdo->prepare("SELECT COUNT(*) FROM students WHERE class_id = ?");
$stmt->execute([$homework['class_id']]);
$total_students = $stmt->fetchColumn();

// --- جلب أول 5 طلاب سلّموا ---
$stmt = $pdo->prepare("SELECT s.*, st.name as student_name FROM submissions s
                       JOIN students st ON s.student_id = st.id
                       WHERE s.homework_id = ?
                       ORDER BY s.submitted_at DESC LIMIT 5");
$stmt->execute([$homework_id]);
$recent_submissions = $stmt->fetchAll();
?>

<?php include '../includes/header.php'; ?>

<div class="container">
    <h2>📄 تفاصيل الواجب</h2>

    <!-- معلومات الواجب -->
    <div style="background: white; padding: 25px; border-radius: 12px; border: 1px solid #ddd; margin-bottom: 30px; box-shadow: 0 2px 10px rgba(0,0,0,0.05);">
        <h3 style="color: #007cba; margin: 0 0 15px 0;"><?php echo htmlspecialchars($homework['title']); ?></h3>
        <p><strong>الوصف:</strong> <?php echo nl2br(htmlspecialchars($homework['description'] ?: 'لا يوجد')); ?></p>
        <p><strong>الصف:</strong> <?php echo htmlspecialchars($homework['class_name']); ?></p>
        
        <?php if ($homework['file_path']): ?>
            <p><strong>ملف التعليمات:</strong> 
               <a href="../assets/uploads/<?php echo $homework['file_path']; ?>" 
                  target="_blank" 
                  style="color: #007cba; text-decoration: underline;">
                  📎 تحميل الملف
               </a>
            </p>
        <?php endif; ?>

        <p><strong>تاريخ الاستحقاق:</strong> 
           <?php echo $homework['due_date'] ? date('Y-m-d H:i', strtotime($homework['due_date'])) : 'غير محدد'; ?>
        </p>
        <p><strong>تاريخ الإنشاء:</strong> <?php echo date('Y-m-d H:i', strtotime($homework['created_at'])); ?></p>
    </div>

    <!-- إحصائيات التسليم -->
    <div style="display: flex; gap: 20px; flex-wrap: wrap; margin-bottom: 30px;">
        <div style="flex: 1; min-width: 200px; padding: 20px; background: #f0f8ff; border-radius: 10px; text-align: center; border: 1px solid #b3d9ff;">
            <h4 style="color: #007cba; margin: 0;">التسليمات</h4>
            <p style="font-size: 24px; font-weight: bold; color: #007cba;"><?php echo $submitted_count; ?> / <?php echo $total_students; ?></p>
            <p style="color: #555; font-size: 14px;">من إجمالي الطلاب</p>
        </div>

        <div style="flex: 1; min-width: 200px; padding: 20px; background: #e8f5e9; border-radius: 10px; text-align: center; border: 1px solid #a5d6a7;">
            <h4 style="color: #2e7d32; margin: 0;">النسبة</h4>
            <p style="font-size: 24px; font-weight: bold; color: #2e7d32;">
                <?php echo $total_students > 0 ? round(($submitted_count / $total_students) * 100) : 0; ?>%
            </p>
            <p style="color: #555; font-size: 14px;">من الطلاب سلّموا</p>
        </div>
    </div>

    <!-- أحدث التسليمات -->
    <h3>🆕 أحدث التسليمات</h3>
    <?php if (count($recent_submissions) > 0): ?>
        <ul style="list-style: none; padding: 0;">
            <?php foreach ($recent_submissions as $sub): ?>
                <li style="padding: 12px; margin: 5px 0; background: #f8f9fa; border-left: 4px solid #007cba; border-radius: 4px; display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <strong><?php echo htmlspecialchars($sub['student_name']); ?></strong>
                        <span style="color: #777; margin-right: 10px;">(<?php echo date('H:i', strtotime($sub['submitted_at'])); ?>)</span>
                    </div>
                    <a href="view_submission.php?homework_id=<?php echo $homework_id; ?>&student_id=<?php echo $sub['student_id']; ?>"
                       style="color: #007cba; text-decoration: underline; font-size: 14px; white-space: nowrap;">
                       عرض التسليم
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
        <p style="text-align: left; margin: 10px 0;">
            <a href="submissions.php?homework_id=<?php echo $homework_id; ?>" style="color: #6c757d; font-size: 14px;">
                ➜ عرض جميع التسليمات (<?php echo $submitted_count; ?>)
            </a>
        </p>
    <?php else: ?>
        <p style="color: #777; font-style: italic; padding: 20px; background: #f8f9fa; border-radius: 8px; text-align: center;">
            لم يُسلّم أي طالب هذا الواجب بعد.
        </p>
    <?php endif; ?>

    <!-- أزرار الإجراءات -->
    <div style="margin-top: 40px; text-align: left;">
        <a href="homeworks.php" class="btn" style="background: #6c757d; margin-right: 10px;">العودة للواجبات</a>
        <a href="submissions.php?homework_id=<?php echo $homework_id; ?>" class="btn" style="background: #007cba;">عرض جميع التسليمات</a>
    </div>
</div>

<?php include '../includes/footer.php'; ?>