<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

if (!isTeacher()) {
    header("Location: ../index.php");
    exit();
}

$teacher_id = $_SESSION['user']['id'];
$homework_id = $_GET['homework_id'] ?? null;
$student_id = $_GET['student_id'] ?? null;

if (!$homework_id || !$student_id) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>بيانات غير كافية.</h3>");
}

// --- التحقق من أن الواجب تابع للمُدرِّس ---
$stmt = $pdo->prepare("SELECT h.*, c.name as class_name FROM homeworks h
                       JOIN classes c ON h.class_id = c.id
                       WHERE h.id = ? AND h.teacher_id = ?");
$stmt->execute([$homework_id, $teacher_id]);
$homework = $stmt->fetch();

if (!$homework) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>غير مسموح لك عرض هذا الواجب.</h3>");
}

// --- التحقق من أن الطالب في نفس الصف ---
$stmt = $pdo->prepare("SELECT id, name, email FROM students WHERE id = ? AND class_id = ?");
$stmt->execute([$student_id, $homework['class_id']]);
$student = $stmt->fetch();

if (!$student) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>الطالب غير موجود في صف هذا الواجب.</h3>");
}

// --- جلب التسليم ---
$stmt = $pdo->prepare("SELECT * FROM submissions WHERE homework_id = ? AND student_id = ?");
$stmt->execute([$homework_id, $student_id]);
$submission = $stmt->fetch();

if (!$submission) {
    die("<h3 style='text-align: center; color: red; margin-top: 50px;'>هذا الطالب لم يُسلّم هذا الواجب بعد.</h3>");
}

// --- معالجة إضافة تعليق من المُدرِّس ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['teacher_comment'])) {
    $message = trim($_POST['message']);
    if (!empty($message)) {
        try {
            $stmt = $pdo->prepare("INSERT INTO submission_comments (submission_id, sender_type, message) VALUES (?, ?, ?)");
            $stmt->execute([$submission['id'], 'teacher', $message]);
        } catch (Exception $e) {
            // يمكنك إظهار خطأ إذا أردت
        }
        // إعادة التحميل لعرض التعليق الجديد
        echo "<script>location.href = location.href;</script>";
    }
}

// --- جلب جميع التعليقات ---
$stmt = $pdo->prepare("SELECT * FROM submission_comments WHERE submission_id = ? ORDER BY created_at ASC");
$stmt->execute([$submission['id']]);
$comments = $stmt->fetchAll();
?>

<?php include '../includes/header.php'; ?>

<div class="container">
    <h2>📄 عرض تسليم الواجب</h2>

    <!-- معلومات الطالب -->
    <div style="background: #f0f8ff; padding: 20px; border-radius: 10px; border: 1px solid #b3d9ff; margin-bottom: 20px;">
        <h3 style="margin: 0; color: #007cba;">👤 الطالب</h3>
        <p><strong>الاسم:</strong> <?php echo htmlspecialchars($student['name']); ?></p>
        <p><strong>البريد:</strong> <?php echo htmlspecialchars($student['email']); ?></p>
    </div>

    <!-- ملف الإجابة -->
    <div style="background: #fff8e1; padding: 20px; border-radius: 10px; border: 1px solid #ffe082; margin-bottom: 20px;">
        <h3 style="margin: 0; color: #e65100;">📥 ملف الإجابة</h3>
        <p>
            <a href="../assets/uploads/<?php echo $submission['file_path']; ?>" 
               target="_blank" 
               style="padding: 10px 20px; background: #e65100; color: white; text-decoration: none; border-radius: 6px; font-weight: 600;">
               تحميل الملف
            </a>
        </p>
        <p style="color: #777; font-size: 14px;">
            تم التسليم في: <?php echo date('Y-m-d H:i', strtotime($submission['submitted_at'])); ?>
        </p>
    </div>

    <!-- الملاحظة الأصلية -->
    <?php if ($submission['note']): ?>
        <div style="background: #e8f5e9; padding: 15px; border-radius: 8px; border: 1px solid #a5d6a7; margin-bottom: 20px;">
            <h4 style="margin: 0 0 8px 0; color: #2e7d32;">📌 الملاحظة الأصلية</h4>
            <pre style="
                background: white;
                padding: 12px;
                border: 1px solid #ccc;
                border-radius: 6px;
                font-size: 14px;
                line-height: 1.6;
                white-space: pre-wrap;
                direction: rtl;
                text-align: right;
                color: #333;
            "><?php echo htmlspecialchars($submission['note']); ?></pre>
        </div>
    <?php endif; ?>

    <!-- سجل التعليقات -->
    <div style="background: #f3f4f6; padding: 20px; border-radius: 10px; border: 1px solid #d1d5db; margin-bottom: 20px;">
        <h3 style="margin: 0 0 15px 0; color: #4b5563;">💬 سجل المحادثة</h3>

        <?php if (count($comments) > 0): ?>
            <div style="display: flex; flex-direction: column; gap: 15px; max-height: 400px; overflow-y: auto; padding: 10px;">
                <?php foreach ($comments as $comment): 
                    $is_teacher = $comment['sender_type'] == 'teacher';
                    $bg = $is_teacher ? '#007cba' : '#6f42c1';
                    $color = 'white';
                    $align = $is_teacher ? 'left' : 'right';
                    $sender = $is_teacher ? 'أنت' : htmlspecialchars($student['name']);
                ?>
                    <div style="text-align: <?php echo $align; ?>;">
                        <div style="
                            display: inline-block;
                            background: <?php echo $bg; ?>;
                            color: <?php echo $color; ?>;
                            padding: 10px 15px;
                            border-radius: 18px;
                            max-width: 80%;
                            font-size: 14px;
                            line-height: 1.5;
                            direction: rtl;
                            text-align: right;
                            word-wrap: break-word;
                        ">
                            <strong><?php echo $sender; ?>:</strong><br>
                            <?php echo nl2br(htmlspecialchars($comment['message'])); ?>
                        </div>
                        <div style="font-size: 12px; color: #777; margin-top: 5px; text-align: <?php echo $align; ?>;">
                            <?php echo date('Y-m-d H:i', strtotime($comment['created_at'])); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p style="color: #777; text-align: center; font-style: italic;">لا توجد تعليقات بعد.</p>
        <?php endif; ?>

        <!-- نموذج إضافة تعليق -->
        <form method="POST" style="margin-top: 20px; text-align: right;">
            <input type="hidden" name="teacher_comment" value="1">
            <div style="margin-bottom: 10px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 600;">أضف تعليقك</label>
                <textarea name="message" rows="3" required
                          style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 6px;"
                          placeholder="اكتب تعليقك على الإجابة..."></textarea>
            </div>
            <button type="submit" style="
                padding: 10px 20px;
                background: #007cba;
                color: white;
                border: none;
                border-radius: 6px;
                font-weight: 600;
            ">
                إرسال التعليق
            </button>
        </form>
    </div>

    <br>
    <a href="submissions.php?homework_id=<?php echo $homework_id; ?>" class="btn" style="background: #6c757d;">
        العودة لقائمة التسليمات
    </a>
</div>

<?php include '../includes/footer.php'; ?>